/***************************************************************************
                          ksig.cpp  -  description
                             -------------------
    begin                : Tue Jul  9 23:14:22 EDT 2002
    copyright            : (C) 2002 by Scott Wheeler
    email                : wheeler@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdeapplication.h>
#include <kstdaction.h>
#include <tdeaction.h>
#include <tdeconfig.h>
#include <tdeglobalsettings.h>
#include <tdemessagebox.h>
#include <kstatusbar.h>
#include <ktextedit.h>
#include <tdelistviewsearchline.h>
#include <tdelocale.h>

#include <tqsplitter.h>

#include "ksig.h"
#include "siglistviewitem.h"
#include "standardtext.h"

////////////////////////////////////////////////////////////////////////////////
// public methods
////////////////////////////////////////////////////////////////////////////////

KSig::KSig(TQWidget *parent, const char *name) : TDEMainWindow(parent, name),
						changed(false)
{
    setupActions();
    setupLayout();
    setupSearchLine();

    if (!initialGeometrySet())
        resize(640,480);
    setupGUI(ToolBar | Keys | StatusBar | Create);
    setAutoSaveSettings();

    readConfig();
    loadData();
}

KSig::~KSig()
{

}

////////////////////////////////////////////////////////////////////////////////
// private methods
////////////////////////////////////////////////////////////////////////////////

void KSig::setupActions()
{
    KStdAction::openNew(this, TQ_SLOT(add()), actionCollection());
    new TDEAction(i18n("Remove"), "edit-delete", 0, this, TQ_SLOT(remove()), actionCollection(), "remove");
    KStdAction::save(this, TQ_SLOT(save()), actionCollection());
    KStdAction::quit(this, TQ_SLOT(quit()), actionCollection());

    KStdAction::cut(kapp, TQ_SLOT(cut()), actionCollection());
    KStdAction::copy(kapp, TQ_SLOT(copy()), actionCollection());
    KStdAction::paste(kapp, TQ_SLOT(paste()), actionCollection());
    new TDEAction(i18n("C&lear"), "edit-clear", 0, kapp, TQ_SLOT(clear()), actionCollection(), "clear");

    new TDEAction(i18n("Edit Standard Header"), 0, 0, this, TQ_SLOT(editHeader()), actionCollection(), "editHeader");
    new TDEAction(i18n("Edit Standard Footer"), 0, 0, this, TQ_SLOT(editFooter()), actionCollection(), "editFooter");
}

void KSig::setupLayout()
{
    splitter = new TQSplitter(TQt::Vertical, this);

    setCentralWidget(splitter);

    sigList = SigListView::instance(splitter, "sigList");

    sigEdit = new KTextEdit(splitter, "sigEdit");
    sigEdit->setTextFormat(TQt::PlainText);
    sigEdit->setFont(TDEGlobalSettings::fixedFont());
    sigEdit->setEnabled(false);
    sigEdit->setCheckSpellingEnabled(true);

    statusBar()->insertItem(i18n(" Line: %1 ").arg(0), LineNumber, 0, true);
    statusBar()->insertItem(i18n(" Col: %1 ").arg(0), ColumnNumber, 0, true);
    statusBar()->show();
    
    updateListLock = false;
    connect(sigEdit, TQ_SIGNAL(textChanged()), this, TQ_SLOT(updateList()));
    connect(sigList, TQ_SIGNAL(selectionChanged()), this, TQ_SLOT(updateEdit()));
    connect(sigEdit, TQ_SIGNAL(cursorPositionChanged(int,int)), this, TQ_SLOT(updateStatus(int,int)));
}

void KSig::setupSearchLine()
{
    TDEListViewSearchLineWidget *searchWidget = new TDEListViewSearchLineWidget(sigList, this);
    new KWidgetAction(searchWidget, i18n("Search"), TDEShortcut(), 0, 0, actionCollection(), "search");
}

void KSig::loadData()
{
    if(sigList->childCount() > 0) {
        sigList->setCurrentItem(sigList->firstChild());
        sigList->setSelected(sigList->firstChild(), true);

        sigEdit->setEnabled(true);
    }
    else {
        updateListLock = true;
        sigEdit->setText(i18n("To get started, first create a new signature by selecting "
                              "\"New\" above. You will then be able to edit and save "
                              "your collection of signatures."));
        updateListLock = false;
    }
    setDataChanged(false);
}

void KSig::readConfig()
{
    setAutoSaveSettings();
    TDEConfig *config = TDEGlobal::config();
    {
	TDEConfigGroupSaver saver(config, "Settings");
	if(splitter) {
	    TQValueList<int> sizes;

	    sizes.append(config->readNumEntry("ListSize", -1));
	    sizes.append(config->readNumEntry("EditSize", -1));

	    if(sizes[0] > 0 && sizes[1] > 0)
		splitter->setSizes(sizes);
	}

	header = config->readEntry("Header");
	footer = config->readEntry("Footer");
    }
}

void KSig::writeConfig()
{
    TDEConfig *config = TDEGlobal::config();
    {
	TDEConfigGroupSaver saver(config, "Settings");
	if(splitter) {
	    TQValueList<int> sizes = splitter->sizes();

	    config->writeEntry("ListSize", sizes[0]);
	    config->writeEntry("EditSize", sizes[1]);
	}

	config->writeEntry("Header", header);
	config->writeEntry("Footer", footer);
    }
    config->sync();
}

bool KSig::queryClose()
{
    if(changed) {
	int saveChanges = KMessageBox::questionYesNoCancel(this, i18n("Do you want to save your changes before exiting?"),TQString(),KStdGuiItem::save(),KStdGuiItem::discard());
	if(saveChanges == KMessageBox::Cancel)
	    return(false);
	else if(saveChanges == KMessageBox::Yes)
	    save();
    }

    writeConfig();
    return(true);
}

////////////////////////////////////////////////////////////////////////////////
// private slots
////////////////////////////////////////////////////////////////////////////////

void KSig::add()
{
    setDataChanged();
    SigListViewItem *sigItem = sigList->createItem();
    sigList->setCurrentItem(sigItem);

    sigEdit->setEnabled(true);
    sigEdit->setFocus();
    sigEdit->clear();
}

void KSig::remove()
{
    setDataChanged();
    sigEdit->clear();
    delete(sigList->currentItem());
}

void KSig::save()
{
    sigList->save();
    setDataChanged(false);
}

void KSig::setDataChanged(bool value)
{
    changed = value;

    if(changed)
	setCaption(kapp->makeStdCaption(TQString(), true, true));
    else
	setCaption(kapp->makeStdCaption(TQString(), true, false));
}

void KSig::editHeader()
{
    StandardText *t = new StandardText(0, 0, true);
    t->setLabel(i18n("Standard signature header:"));
    t->setText(header);
    
    connect(t, TQ_SIGNAL(textUpdated(const TQString &)), this, TQ_SLOT(setHeader(const TQString &)));
    
    t->exec();
}

void KSig::editFooter()
{
    StandardText *t = new StandardText(0, 0, true);
    t->setLabel(i18n("Standard signature footer:"));
    t->setText(footer);
    
    connect(t, TQ_SIGNAL(textUpdated(const TQString &)), this, TQ_SLOT(setFooter(const TQString &)));
    
    t->exec();
}

void KSig::updateList()
{
    if(!updateListLock) {
	setDataChanged();
	SigListViewItem *item = sigList->currentItem();
	if(item)
	    item->setText(sigEdit->text());
    }
}

void KSig::updateEdit()
{
    updateListLock = true;

    SigListViewItem *item = sigList->currentItem();
    if(item)
	sigEdit->setText(item->text());

    updateListLock = false;
}

void KSig::updateStatus(int line, int column)
{
    statusBar()->changeItem(i18n(" Line: %1 ").arg(line + 1), LineNumber);
    statusBar()->changeItem(i18n(" Col: %1 ").arg(column + 1), ColumnNumber);
}

void KSig::quit()
{
    close();
}

#include "ksig.moc"
