/* This file is part of the KDE project

Copyright (C) 2001, 2003 Lukas Tinkl <lukas@kde.org>
Andreas Schlapbach <schlpbch@iam.unibe.ch>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License version 2 as published by the Free Software Foundation.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.
*/

#ifndef kimgalleryplugin_h
#define kimgalleryplugin_h

#include <tdeparts/plugin.h>
#include <klibloader.h>
#include <konq_dirpart.h>
#include <tdeio/jobclasses.h>

class TQProgressDialog;
class KURL;
class KIGPDialog;

typedef TQMap<TQString,TQString> CommentMap;

class KImGalleryPlugin : public KParts::Plugin
{
  TQ_OBJECT
  
    public:
  KImGalleryPlugin( TQObject* parent, const char* name,
	            const TQStringList & );
  ~KImGalleryPlugin() {}

  public slots:
    void slotExecute();
  void slotCancelled();

 private:
  bool m_cancelled;
  bool m_recurseSubDirectories;
  bool m_copyFiles;
  bool m_useCommentFile;

  int m_imgWidth;
  int m_imgHeight;
  int m_imagesPerRow;

  TQProgressDialog *m_progressDlg;

  KonqDirPart* m_part;

  KIGPDialog *m_configDlg;

  CommentMap* m_commentMap;

  bool createDirectory(TQDir thumb_dir, TQString imgGalleryDir, TQString dirName);

  void createHead(TQTextStream& stream);
  void createCSSSection(TQTextStream& stream);
  void createBody(TQTextStream& stream, const TQString& sourceDirName, const TQStringList& subDirList, const TQDir& imageDir, const KURL& url, const TQString& imageFormat);

  bool createThumb( const TQString& imgName, const TQString& sourceDirName, const TQString& imgGalleryDir, const TQString& imageFormat);

  bool createHtml( const KURL& url, const TQString& sourceDirName, int recursionLevel, const TQString& imageFormat);
  void deleteCancelledGallery( const KURL& url, const TQString& sourceDirName, int recursionLevel, const TQString& imageFormat);
  void loadCommentFile();

  static TQString extension(const TQString& imageFormat);
};

#endif
