// Copyright (c) 2001 Frerich Raabe <raabe@kde.org>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIAB\ILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

#ifndef PARSEDMP3FILENAME_H
#define PARSEDMP3FILENAME_H

#include <tqstringlist.h>

class ParsedMP3FileName
{
public:
	ParsedMP3FileName(const TQString &);
	~ParsedMP3FileName() {}

	TQString title() const { return m_title; }
	TQString artist() const { return m_artist; }
	TQString album() const { return m_album; }
	TQString comment() const { return m_comment; }

protected:
	TQString m_title;
	TQString m_artist;
	TQString m_album;
	TQString m_comment;

private:
	void validateArtist();
	TQString beautifyString(const TQString &);

	TQStringList m_directories;
};

#endif
