
  

#ifndef KJSEMBED_QCanvasEllipse_H
#define KJSEMBED_QCanvasEllipse_H

#include <kjs/interpreter.h>
#include <kjs/object.h>

#include <kjsembed/jsobjectproxy_imp.h>

class TQCanvasEllipse;

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

/**
 * Wrapper class for TQCanvasEllipse methods.
 *
 * @author Richard Moore, rich@kde.org
 */
class TQCanvasEllipseImp : public JSProxyImp
{
public:
   /** Enumerates the constructors supported by this class. */
   enum Constructors {
       Constructor_QCanvasEllipse_1,
       Constructor_QCanvasEllipse_2,
       Constructor_QCanvasEllipse_3,

       LastConstuctor = -1
   };

   /** Enumerates the methods supported by this class. */
   enum Methods {

       Method_width_5,
       Method_height_6,
       Method_setSize_7,
       Method_setAngles_8,
       Method_angleStart_9,
       Method_angleLength_10,
       Method_areaPoints_11,
       Method_collidesWith_12,
       Method_rtti_13,
       Method_Last = -1
   };

   TQCanvasEllipseImp( KJS::ExecState *exec, int id, bool constructor=false );
   ~TQCanvasEllipseImp();

   /**
    * Adds the static bindings for this class to the specified Object. The
    * static bindings are the static methods and the enums of this class.
    */
   static void addStaticBindings( KJS::ExecState *exec, KJS::Object &object );

   /**
    * Adds the bindings for this class to the specified Object. The bindings
    * added are the instance methods of this class.
    */
   static void addBindings( KJS::ExecState *exec, KJS::Object &object );

   static TQCanvasEllipse *toTQCanvasEllipse( KJS::Object &object );

   //
   // Constructors implemented by this class.
   //

   KJS::Object TQCanvasEllipse_1( KJS::ExecState *exec, const KJS::List &args );
   KJS::Object TQCanvasEllipse_2( KJS::ExecState *exec, const KJS::List &args );
   KJS::Object TQCanvasEllipse_3( KJS::ExecState *exec, const KJS::List &args );

   //
   // Methods implemented by this class.
   //

   KJS::Value width_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value height_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setSize_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setAngles_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value angleStart_9( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value angleLength_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value areaPoints_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value collidesWith_12( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value rtti_13( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );

   //
   // JS binding code.
   //

   /** Returns true iff this object implements the construct function. */
   virtual bool implementsConstruct() const { return cons; }

   /** Invokes the construct function. */
   virtual KJS::Object construct( KJS::ExecState *exec, const KJS::List &args );

   /** Returns true iff this object implements the call function. */
   virtual bool implementsCall() const { return !cons; }

   /** Invokes the call function. */
   virtual KJS::Value call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args );

private:
   TQCanvasEllipse *instance; // Temp
   int id;
   bool cons;
};

} // namespace KJSEmbed

#endif // KJSEMBED_QCanvasEllipse_H
