import org.trinitydesktop.qt.*;

public class Tut12 extends TQWidget {
	public Tut12() {
		TQPushButton quit = new TQPushButton("&Quit", this, "quit");
		quit.setFont(new TQFont("Times", 18, TQFont.Bold, false));

		connect(quit, TQ_SIGNAL("clicked()"), tqApp(), TQ_SLOT("quit()"));

		LCDRange angle = new LCDRange("ANGLE", this, "angle");
		angle.setRange(5, 70);

		LCDRange force = new LCDRange("FORCE", this, "force");
		force.setRange(10, 50);

		CannonField cannonField = new CannonField(this, "cannonField");

		connect(angle, TQ_SIGNAL("valueChanged(int)"),
						cannonField, TQ_SLOT("setAngle(int)"));
		connect(cannonField, TQ_SIGNAL("angleChanged(int)"),
						angle, TQ_SLOT("setValue(int)"));

		connect(force, TQ_SIGNAL("valueChanged(int)"),
						cannonField, TQ_SLOT("setForce(int)"));
		connect(cannonField, TQ_SIGNAL("forceChanged(int)"),
						force, TQ_SLOT("setValue(int)"));


		TQPushButton shoot = new TQPushButton("&Shoot", this, "shoot");
		shoot.setFont(new TQFont("Times", 18, TQFont.Bold, false));

		connect(shoot, TQ_SIGNAL("clicked()"), cannonField, TQ_SLOT("shoot()"));

		TQGridLayout grid = new TQGridLayout(this, 2, 2, 10, -1, null);
		grid.addWidget(quit, 0, 0);
		grid.addWidget(cannonField, 1, 1);
		grid.setColStretch(1, 10);

		TQVBoxLayout leftBox = new TQVBoxLayout();
		grid.addLayout(leftBox, 1, 0);
		leftBox.addWidget(angle);
		leftBox.addWidget(force);

		TQHBoxLayout topBox = new TQHBoxLayout();
		grid.addLayout(topBox, 0, 1);
		topBox.addWidget(shoot);
		topBox.addStretch(1);

		angle.setValue(60);
		force.setValue(25);
		angle.setFocus();
	}
	
	public static void main(String[] args) {
		TQApplication.setColorSpec(TQApplication.CustomColor);
		TQApplication a = new TQApplication(args);
		Tut12 w = new Tut12();
		w.setGeometry( 100, 100, 500, 355 );
		
		a.setMainWidget(w);
		w.show();
		a.exec();
		return;
	}
	
	static {
		try {
			Class c = Class.forName("org.trinitydesktop.qt.qtjava");
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Can't load qtjava class");
		}
	}
}
