require 'Qt'

class CannonField < TQt::Widget
	signals 'angleChanged(int)'
	slots 'setAngle(int)'
	
	def initialize(parent, name)
		super
		@ang = 45
    	setPalette( TQt::Palette.new( TQt::Color.new( 250, 250, 200) ) )
	end

	def setAngle( degrees )
		if degrees < 5
			degrees = 5
		elsif degrees > 70
        	degrees = 70
		end
		if @ang == degrees
			return
		end
		@ang = degrees
		repaint()
		emit angleChanged( @ang )
	end

	def paintEvent( event )
		s = "Angle = #{@ang}"
		p = TQt::Painter.new( self )
		p.drawText( 200, 200, s )
		p.end()
	end


	def sizePolicy()
    	return TQt::SizePolicy.new( TQt::SizePolicy::Expanding, TQt::SizePolicy::Expanding )
	end
end
