//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.Qt;
import org.trinitydesktop.qt.TQMetaObject;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQPopupMenu;
import org.trinitydesktop.qt.TQPixmap;
import org.trinitydesktop.qt.TQWidget;
import org.trinitydesktop.qt.TQDomElement;

/**

 A special kind of TDEMainWindow that is able to have dockwidget child widgets (and member of the dockwidget class set).
 The main widget should be a KDockWidget where other KDockWidget can be docked to
 the left, right, top, bottom or to the middle.
 Note: dock to the middle means to drop on a dockwidget and to unite them to a new widget, a tab control.
 Furthermore, the KDockMainWindow has got the KDockManager and some data about the dock states.
 If you've got some dockwidgets, you can dock them to the dockmainwindow to initialize a start scene:
 Here an example:
 <pre>
 DockApplication.DockApplication( String name)
 {
   ...
   KDockWidget mainDock;
   mainDock = createDockWidget( "Falk's MainDockWidget", mainPixmap, null, "main_dock_widget");
   AnyContentsWidget cw = new AnyContentsWidget( mainDock);
   mainDock.setWidget( cw);
   // allow others to dock to the 4 sides
   mainDock.setDockSite(KDockWidget.DockCorner);
   // forbit docking abilities of mainDock itself
   mainDock.setEnableDocking(KDockWidget.DockNone);
   setView( mainDock); // central widget in a KDE mainwindow
   setMainDockWidget( mainDock); // master dockwidget
   ...
   KDockWidget dockLeft;
   dockLeft = createDockWidget( "Intially left one", anyOtherPixmap, null, i18n("The left dockwidget"));
   AnotherWidget aw = new AnotherWidget( dockLeft);
   dockLeft.setWidget( aw);
   dockLeft.manualDock( mainDock,              // dock target
                         KDockWidget.DockLeft, // dock site
                         20 );                  // relation target/this (in percent)
   ...
 </pre>
 Docking is fully dynamic at runtime. That means you can always move dockwidgets via drag and drop.
 And last but not least you can use the popupmenu for showing or hiding any controlled dockwidget
 of this class and insert it to your main menu bar or anywhere else.
 See {@link KDockMainWindowSignals} for signals emitted by KDockMainWindow
		@author Max Judin (documentation: Falk Brettschneider).

		@short    A special kind of TDEMainWindow that is able to have dockwidget child widgets (and member of the dockwidget class set).

*/
public class KDockMainWindow extends TDEMainWindow  {
	protected KDockMainWindow(Class dummy){super((Class) null);}
	public native TQMetaObject metaObject();
	public native String className();
	/**
		 Constructs a dockmainwindow. It calls its base class constructor and does additional things concerning
		 to the dock stuff:

			<li>
			information about the dock state of this' children gets initialized
			</li>

			<li>
			a dockmanager is created...
			</li>

			<li>
			...and gets initialized
			</li>

			<li>
			the main dockwidget is set to 0
			</li>
				@param parent Parent widget for the dock main widget
			@param name internal object name
			@param f Qt.WidgetFlags widget flags
		   		@short    Constructs a dockmainwindow.
	*/
	public KDockMainWindow(TQWidget parent, String name, int f) {
		super((Class) null);
		newKDockMainWindow(parent,name,f);
	}
	private native void newKDockMainWindow(TQWidget parent, String name, int f);
	public KDockMainWindow(TQWidget parent, String name) {
		super((Class) null);
		newKDockMainWindow(parent,name);
	}
	private native void newKDockMainWindow(TQWidget parent, String name);
	public KDockMainWindow(TQWidget parent) {
		super((Class) null);
		newKDockMainWindow(parent);
	}
	private native void newKDockMainWindow(TQWidget parent);
	public KDockMainWindow() {
		super((Class) null);
		newKDockMainWindow();
	}
	private native void newKDockMainWindow();
	/**
		 Returns the dockmanager of this. (see KDockManager)
				@return pointer to the wanted dockmanager

		@short    Returns the dockmanager of this.
	*/
	public native KDockManager manager();
	/**
		 Sets a new main dockwidget.
		 Additionally, the toolbar is re-initialized.
			@param dockwidget dockwidget that become the new main dockwidget
		   		@short    Sets a new main dockwidget.
	*/
	public native void setMainDockWidget(KDockWidget dockwidget);
	/**
		 Returns the main dockwidget.
				@return pointer to the main dockwidget

		@short    Returns the main dockwidget.
	*/
	public native KDockWidget getMainDockWidget();
	/**
		 This is one of the most important methods!
		 The KDockMainWindow creates a new dockwidget object here that usually should encapsulate the user's widget.
		 The new dockwidget is automatically taken under control by the dockmanager of the dockmainwindow.
			@param name TQObject name (default dockwidget caption)
			@param pixmap window icon (for instance shown when docked as tabwidget entry)
			@param parent parent widget for the new dockwidget
			@param strCaption window title (shown when toplevel)
			@param strTabPageLabel title of the tab page (visible when in tab page mode), if it is "", only the icon will be shown; if it is null, the label is set to strCaption
				@return a pointer to the new created dockwidget

		@short    This is one of the most important methods!  The KDockMainWindow creates a new dockwidget object here that usually should encapsulate the user's widget.
	*/
	public native KDockWidget createDockWidget(String name, TQPixmap pixmap, TQWidget parent, String strCaption, String strTabPageLabel);
	public native KDockWidget createDockWidget(String name, TQPixmap pixmap, TQWidget parent, String strCaption);
	public native KDockWidget createDockWidget(String name, TQPixmap pixmap, TQWidget parent);
	public native KDockWidget createDockWidget(String name, TQPixmap pixmap);
	/**
		 Saves the current dock window layout into a DOM tree below the given element.
		   		@short    Saves the current dock window layout into a DOM tree below the given element.
	*/
	public native void writeDockConfig(TQDomElement base);
	/**
		 Reads the current dock window layout from a DOM tree below the given element.
		   		@short    Reads the current dock window layout from a DOM tree below the given element.
	*/
	public native void readDockConfig(TQDomElement base);
	/**
		 It writes the current dock state in the given section of TDEConfig.
			@param c KDE class for saving configurations
			@param group name of section to write to
		   		@short    It writes the current dock state in the given section of TDEConfig.
	*/
	public native void writeDockConfig(TDEConfig c, String group);
	public native void writeDockConfig(TDEConfig c);
	public native void writeDockConfig();
	/**
		 It reads the current dock state from the given section of TDEConfig.
			@param c KDE class for saving configurations
			@param group name of section to read from
		   		@short    It reads the current dock state from the given section of TDEConfig.
	*/
	public native void readDockConfig(TDEConfig c, String group);
	public native void readDockConfig(TDEConfig c);
	public native void readDockConfig();
	/**
		 It runs through all dockwidgets which are under control of the dockmanager and calls show() for every
		 encapsulated widget and show() for the dockwidget itself if it is not in tab mode.
		 Additionally, if the main dockwidget is not a TQDialog, it will be shown.
		   		@short    It runs through all dockwidgets which are under control of the dockmanager and calls show() for every  encapsulated widget and show() for the dockwidget itself if it is not in tab mode.
	*/
	public native void activateDock();
	/**
		 Returns a popup menu that contains entries for all controlled dockwidgets making hiding and showing
		 them possible.
				@return the wanted popup menu

		@short    Returns a popup menu that contains entries for all controlled dockwidgets making hiding and showing  them possible.
	*/
	public native TQPopupMenu dockHideShowMenu();
	/**
		 This method shows the given dockwidget.
		 The clue is that it also considers the dockwidget could be a tab page
		 and must set to be the activate one.
			@param dock the dockwidget that is to be shown
		   		@short    This method shows the given dockwidget.
	*/
	public native void makeDockVisible(KDockWidget dock);
	/**
		 This method hides the given dockwidget.
			@param dock the dockwidget that is to be shown
		   		@short    This method hides the given dockwidget.
	*/
	public native void makeDockInvisible(KDockWidget dock);
	/**
		 This is an overloaded member function, provided for convenience.
		 It differs from the above function only in what argument(s) it accepts.
		   		@short    This is an overloaded member function, provided for convenience.
	*/
	public native void makeWidgetDockVisible(TQWidget widget);
	/**
		 This method calls the base class method.
		 If the given widget inherits KDockWidget, applyToWidget(this) is called.
			@param widget any widget that should become the main view
		   		@short    This method calls the base class method.
	*/
	public native void setView(TQWidget widget);
	/**
		 Called whenever one of the dockwidgets of this has been undocked.
		  		@short    Called whenever one of the dockwidgets of this has been undocked.
	*/
	protected native void slotDockWidgetUndocked();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
