import org.trinitydesktop.qt.*;
import org.trinitydesktop.koala.*;

//
// Simple little hack to show off blending effects.
//
// (C) KDE Artistic Cristian Tibirna <tibirna@kde.org>
//

/**
 *  Class to test KImageEffect blending effects.
 *
 *  This is a translation to java from kblendtest.cpp in the tests library
 *  of tdeui source.
 *
 * @see TDEApplication
 * @see KImageEffect
 *
 * @author Cristian Tibirna <tibirna@kde.org>, java translation Kenneth J. Pouncey, kjpou@hotmail.com
 * @version 0.1
 */

public class KBlendTest {

   public static void main(String[] args) {
      TDECmdLineArgs.init(args, "kblendtest", "KBlendTest", "It blends!", "0.1");
      TDEApplication app = new TDEApplication();
      KBlendWidget w = new KBlendWidget(null,"KBlendTest");
      w.setCaption(app.name());
      app.setMainWidget(w);
      w.show();
      app.exec();
      return;
   }


   public static class KBlendWidget extends TQWidget {

      TQImage image;
      TQColor bgnd;

      String testImage = "testimage.png";

      public KBlendWidget (TQWidget parent, String name) {

         // change the colors to see the effects.
//         bgnd = new TQColor(TQColor.qRgb(255, 255, 255));
         bgnd = Qt.blue();
//         bgnd = Qt.red();

         image = new TQImage(testImage);

         resize(image.width()*2+60, image.height()*3+80);
         setBackgroundColor(bgnd);
      }

      protected void paintEvent(TQPaintEvent pe ) {

         long it, ft;
         String say = "";

         image = new TQImage(testImage);

         TQPainter p = new TQPainter(this);

         p.setPen(Qt.black());

         // you see here use of anti_dir param (blend from down to up, here)
         it = System.currentTimeMillis();
         KImageEffect.blend(image, 0.2f, bgnd, KImageEffect.VerticalGradient,true);
         ft = System.currentTimeMillis();
         say = (ft - it) + " ms, Vertical";
         p.drawImage(20, 20, image);
         p.drawText(5 , 15, say);

         image = new TQImage(testImage);

         // here a negative initial intensity is used (1/2 of image is unaffected)
         it = System.currentTimeMillis();
         KImageEffect.blend(image, -0.5f, bgnd, KImageEffect.HorizontalGradient);
         ft = System.currentTimeMillis();
         say = (ft - it) + " ms, Horizontal";
         p.drawImage(40+image.width(), 20, image);
         p.drawText(15+image.width() , 15, say);

         image = new TQImage(testImage);

         it = System.currentTimeMillis();
         KImageEffect.blend(image, 0.0f, bgnd, KImageEffect.DiagonalGradient,true);
         ft = System.currentTimeMillis();
         say = (ft - it) + " ms, Diagonal";
         p.drawImage(20, 40+image.height(), image);
         p.drawText(5 , 35+image.height(), say);

         image = new TQImage(testImage);

         it = System.currentTimeMillis();
         KImageEffect.blend(image, 0.1f, bgnd, KImageEffect.CrossDiagonalGradient);
         ft = System.currentTimeMillis();
         say = (ft - it) + " ms, CrossDiagonal";
         p.drawImage(40+image.width(), 40+image.height(), image);
         p.drawText(25+image.width() , 35 + image.height(), say);

         image = new TQImage(testImage);

         it = System.currentTimeMillis();
         KImageEffect.blend(image, -0.6f, bgnd, KImageEffect.RectangleGradient);
         ft = System.currentTimeMillis();
         say = (ft - it) + " ms, Rectangle";
         p.drawImage(20, 60+2*image.height(), image);
         p.drawText(5 , 55+2*image.height(), say);

         image = new TQImage(testImage);

         it = System.currentTimeMillis();
         KImageEffect.blend(image, 0.2f, bgnd, KImageEffect.EllipticGradient);
         ft = System.currentTimeMillis();
         say = (ft - it) + " ms, Elliptic";
         p.drawImage(40+image.width(), 60+2*image.height(), image);
         p.drawText(25+image.width(), 55+2*image.height(), say);
         p.end();
      }
   }

   static {
      qtjava.initialize();
      tdejava.initialize();
   }

}
