/*
 * Copyright (C) 2003 Julian Rockey <kde@jrockey.com>
 */

#include "tdedcoptest.h"
#include <tdeapplication.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>

static const char *description =
    I18N_NOOP("A TDE KPart Application");

static const char *version = "0.1";

static TDECmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
    { 0, 0, 0 }
};

int main(int argc, char **argv)
{
    TDEAboutData about("tdedcoptest", I18N_NOOP("TDEDcopTest"), version, description,
                     TDEAboutData::License_GPL, "(C) 2003 Julian Rockey", 0, 0, "kde@jrockey.com");
    about.addAuthor( "Julian Rockey", 0, "kde@jrockey.com" );
    TDECmdLineArgs::init(argc, argv, &about);
    TDECmdLineArgs::addCmdLineOptions( options );
    TDEApplication app;
    KDEDcopTest *mainWin = 0;

    if (app.isRestored())
    {
        RESTORE(KDEDcopTest);
    }
    else
    {
        // no session.. just start up normally
        TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

        // TODO: do something with the command line args here

        mainWin = new KDEDcopTest();
        app.setMainWidget( mainWin );
        mainWin->show();

        args->clear();
    }

    int ret = app.exec();

    delete mainWin;
    return ret;
}
