/***************************************************************************

                     clipboard part of kvoctrain

    -----------------------------------------------------------------------

    begin                : Thu Mar 11 20:50:53 MET 1999

    copyright            : (C) 1999-2001 Ewald Arnold
                           (C) 2001 The KDE-EDU team

    email                : kvoctrain@ewald-arnold.de

    -----------------------------------------------------------------------

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kvoctrain.h"

#include <tqclipboard.h>

#include <klineedit.h>
#include <tdelocale.h>

#include "prefs.h"
#include <algorithm>
using namespace std;

extern vector<int> getCsvOrderStatic(kvoctrainDoc *doc);

void kvoctrainApp::slotSmartSearchClip()
{
  TQString s;
  TQString entries = TQApplication::clipboard()->text();

  if (!entries.isEmpty()) {
    int pos = entries.find ('\n'); // search for a line end
    if (pos < 0)
      pos = entries.find ('\r');

    if (pos < 0)    // just first "line"
      s = entries;
    else
      s = entries.left(pos);

    searchpos = 0;                      // search from beginning
    searchstr = s.stripWhiteSpace();    // in case RETURN is pressed
    searchLine->setFocus();
    searchLine->setText (searchstr);
  }
  else
    searchLine->setFocus();
}


vector<int> kvoctrainApp::getCsvOrder(kvoctrainDoc *doc)
{
  return getCsvOrderStatic(doc);
}


void kvoctrainApp::slotEditCopy()
{
  slotStatusMsg(i18n("Copying selection to clipboard..."));

  TQApplication::setOverrideCursor( waitCursor );
  TQString exp;
  TQString s;

  vector <int> csv_order = getCsvOrder(doc);

  KVocTrainTable *table = view->getTable();

  for (int j = table->numRows()-1; j >= 0; j--) {
    if (table->isRowSelected(j))
    {
      kvoctrainExpr *expr = table->getRow(j);
      if (expr == 0 ) return;

      bool sep =  false;
      for (int i = 0; i < (int) csv_order.size(); i++) {
        if (!sep)
          sep = true;
        else
          exp += Prefs::separator();

        if (csv_order[i] >= 0) {
          if (csv_order[i] == 0)
            exp += expr->getOriginal();
          else
            exp += expr->getTranslation(csv_order[i]);
        }
      }
    }
    if (!exp.isEmpty())
      exp += '\n';
  }
  if (!exp.isEmpty()) {
#if defined(_WS_X11_)
//    disconnect(TQApplication::clipboard(),TQ_SIGNAL(dataChanged()),this,0);
#endif
    TQApplication::clipboard()->setText(exp);
#if defined(_WS_X11_)
//    connect(TQApplication::clipboard(),TQ_SIGNAL(dataChanged()), this,TQ_SLOT(clipboardChanged()));
#endif
  }

  TQApplication::restoreOverrideCursor();
  slotStatusMsg(IDS_DEFAULT);
}


void kvoctrainApp::slotEditPaste()
{
  slotStatusMsg(i18n("Inserting clipboard contents..."));

  TQApplication::setOverrideCursor( waitCursor );
  TQString s;
  TQString entries = TQApplication::clipboard()->text();

  vector <int> csv_order = getCsvOrder(doc);

  bool changed = false;
  TQString num;
// view->setView(0, langset, gradecols);
  while (!entries.isEmpty()) {
    int pos = entries.find ('\n'); // search for a line end
    if (pos < 0) {
      pos = entries.find ('\r');   // mac style ?
    }

    if (pos < 0) {
      s = entries;
      entries = "";
    }
    else {
      s = entries.left(pos);
      entries.remove (0, pos+1);
    }

    // similar block in kvd_csv.cpp::loadFromCsv()

    if (!s.stripWhiteSpace().isEmpty()) {
      if (Prefs::pasteOrder().count() != 0) {
        kvoctrainExpr bucket (s, Prefs::separator(), act_lesson);
        kvoctrainExpr expr;
        expr.setLesson(act_lesson);
        // now move columns according to paste-order
        TQString s;
        for (int i = 0; i < (int) csv_order.size(); i++) {
          if (csv_order[i] >= 0) {
            if (i == 0)
              s = bucket.getOriginal();
            else
              s = bucket.getTranslation(i);

            if (csv_order[i] == 0)
              expr.setOriginal(s);
            else
              expr.setTranslation(csv_order[i], s);
          }
        }
        changed = true;
        doc->appendEntry (&expr);
      }
      else {
        kvoctrainExpr expr (s, Prefs::separator(), act_lesson);
        changed = true;
        doc->appendEntry (&expr);
      }
    }
  }

  if (changed) {
    doc->setModified();
    view->getTable()->updateContents(view->getTable()->numRows()-1, KV_COL_ORG);
  }

  TQApplication::restoreOverrideCursor();
  slotStatusMsg(IDS_DEFAULT);
}


