###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


##### check for ocaml/facile

if( WITH_OCAML_SOLVER )

  if( NOT DEFINED HAVE_OCAML )
    message( STATUS "Search for ocaml" )

    foreach( _exec ocamlc ocamldep ocamlopt )
      string( TOUPPER "${_exec}_EXECUTABLE" _exec_var )
      if( NOT DEFINED ${_exec_var} )
        find_program( ${_exec_var} NAMES ${_exec} )
        if( NOT ${_exec_var} )
          tde_message_fatal( "${_exec} is requested, but was not found on your system" )
        endif( )
      endif( )
    endforeach( )

    if( NOT DEFINED OCAML_BASEDIR )
      execute_process(
        COMMAND ${OCAMLOPT_EXECUTABLE} -where
        OUTPUT_VARIABLE OCAML_BASEDIR
        ERROR_VARIABLE OCAML_BASEDIR
        OUTPUT_STRIP_TRAILING_WHITESPACE
        ERROR_STRIP_TRAILING_WHITESPACE
      )
      if( EXISTS ${OCAML_BASEDIR} AND IS_DIRECTORY ${OCAML_BASEDIR} )
        set( OCAML_BASEDIR ${OCAML_BASEDIR} CACHE PATH "Ocaml base directory" )
        set( OCAML_LIBRARY_DIR ${OCAML_BASEDIR} CACHE PATH "Ocaml libraries directory" )
      else( )
        tde_message_fatal( "Ocaml is requested, but was not found on your system" )
      endif( )
    endif( )

    set( HAVE_OCAML 1 CACHE INTERNAL "" )
    message( STATUS "Search for ocaml - found" )
  endif( )


  if( NOT DEFINED HAVE_FACILE )
    message( STATUS "Search for facile" )

    if( NOT DEFINED FACILE_LIBRARIES )
      find_library( FACILE_LIBRARIES
        NAMES facile.a
        HINTS ${OCAML_BASEDIR}
        PATH_SUFFIXES facile ocaml/facile
      )
    endif( )

    if( NOT DEFINED FACILE_INCLUDE_DIR )
      find_path( FACILE_INCLUDE_DIR
          NAMES facile.cmi
          HINTS ${OCAML_BASEDIR}
          PATH_SUFFIXES facile lib/ocaml/facile
      )
    endif( )

    if( (NOT FACILE_LIBRARIES) OR (NOT FACILE_INCLUDE_DIR) )
      tde_message_fatal( "Facile is requested, but was not found on your system" )
    endif( )

    set( HAVE_FACILE 1 CACHE INTERNAL "Enable build with ocaml/facile" )
    message( STATUS "Search for facile - found" )
  endif( )


  if( NOT DEFINED HAVE_NUMS )
    message( STATUS "Search for nums" )

    if( NOT DEFINED NUMS_LIBRARIES )
      find_library( NUMS_LIBRARY
        NAMES nums.a
        HINTS ${OCAML_BASEDIR}
        PATH_SUFFIXES num ocaml/num
      )
      if( NUMS_LIBRARY )
        set( NUMS_LIBRARIES ${NUMS_LIBRARY} )
      endif()
    endif( )

    if( NOT DEFINED NUMS_INCLUDE_DIR )
      find_path( NUMS_INCLUDE_DIR
          NAMES num.cmi
          HINTS ${OCAML_BASEDIR}
          PATH_SUFFIXES nums lib/ocaml/nums
      )
    endif( )

    if( NUMS_LIBRARIES AND NUMS_INCLUDE_DIR )
      set( HAVE_NUMS 1 CACHE INTERNAL "Enable build with ocaml/nums" )
      message( STATUS "Search for nums - found" )
    else()
      message( STATUS "Search for nums - not found" )
    endif()
  endif( )


  if( NOT DEFINED HAVE_ZARITH )
    message( STATUS "Search for zarith" )

    if( NOT DEFINED ZARITH_LIBRARIES )
      find_library( ZARITH_LIBRARY
        NAMES zarith.a
        HINTS ${OCAML_BASEDIR}
        PATH_SUFFIXES zarith ocaml/zarith
      )
      if( ZARITH_LIBRARY )
        set( ZARITH_LIBRARIES ${ZARITH_LIBRARY} )
      endif()
    endif( )

    if( NOT DEFINED ZARITH_INCLUDE_DIR )
      find_path( ZARITH_INCLUDE_DIR
          NAMES z.cmi
          HINTS ${OCAML_BASEDIR}
          PATH_SUFFIXES zarith lib/ocaml/zarith
      )
    endif( )

    if( ZARITH_LIBRARIES AND ZARITH_INCLUDE_DIR )
      set( HAVE_ZARITH 1 CACHE INTERNAL "Enable build with ocaml/zarith" )
      message( STATUS "Search for zarith - found" )
    else()
      message( STATUS "Search for zarith - not found" )
    endif()
  endif( )

  if( (NOT HAVE_NUMS) AND (NOT HAVE_ZARITH) )
    tde_message_fatal( "Facile requires nums or zarith, but neither is found on your system" )
  endif()

endif( WITH_OCAML_SOLVER )
