// Copyright (C)  2002  Dominique Devriese <devriese@kde.org>

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
// 02110-1301, USA.

#include "textlabelwizard.h"
#include "textlabelwizard.moc"

#include "label.h"
#include "linkslabel.h"

#include <tqtextedit.h>
#include <tdeapplication.h>

#include <tqlayout.h>

TextLabelWizard::TextLabelWizard( TQWidget* parent, TextLabelModeBase* mode )
  : TextLabelWizardBase( parent, "TextLabelWizard", false ), mmode( mode )
{
  connect( labelTextInput, TQ_SIGNAL( textChanged() ),
           TQ_SLOT( textChanged() ) );
  connect( myCustomWidget1, TQ_SIGNAL( linkClicked( int ) ),
           TQ_SLOT( linkClicked( int ) ) );
  connect( this, TQ_SIGNAL( helpClicked() ),
           this, TQ_SLOT( slotHelpClicked() ) );
  labelTextInput->setFocus();
}

TextLabelWizard::~TextLabelWizard()
{
}

void TextLabelWizard::back()
{
  if ( currentPage() == select_arguments_page )
  {
    mmode->enterTextPageEntered();
  }
  TextLabelWizardBase::back();
}

void TextLabelWizard::next()
{
  if ( currentPage() == enter_text_page )
  {
    mmode->selectArgumentsPageEntered();
  }
  TextLabelWizardBase::next();
}

void TextLabelWizard::reject()
{
  TextLabelWizardBase::reject();
  mmode->cancelPressed();
}

void TextLabelWizard::accept()
{
  mmode->finishPressed();
}

void TextLabelWizard::textChanged()
{
  mmode->labelTextChanged();
}

void TextLabelWizard::linkClicked( int which )
{
  mmode->linkClicked( which );
}

void TextLabelWizard::relayoutArgsPage()
{
  select_arguments_pageLayout->activate();
  repaint();
}

void TextLabelWizard::slotHelpClicked()
{
  kapp->invokeHelp( TQString::fromLatin1( "text-labels" ),
                    TQString::fromLatin1( "kig" ) );
}

