#ifndef __MY_MAIN_VIEW_H
#define __MY_MAIN_VIEW_H

#include <tqwidget.h>
#include <tqimage.h>

class TDEToggleAction;
class TDEActionCollection;
#include <krandomsequence.h>

#include "sprites.h"
#include "dialogs.h"
class Ai;

#ifdef sun
#undef sun
#endif

class MyMainView:public TQWidget
{
   TQ_OBJECT
  
public:
   MyMainView(TQWidget *parent=0);
   ~MyMainView();

   static TDEToggleAction *pauseAction;
   void setActionCollection(TDEActionCollection *a);

public slots:
   void newRound();
   void newGame();
   void togglePause( );
   void pause();
   void resume();
   void start();
   void stop();
   void gameSetup();
   void closeSettings();
   void readConfig();
   void writeConfig();
signals:
   void hitPoints(int pn,int hp);
   void energy(int pn,int en);
   void wins(int pn,int w);
   void setStatusText(const TQString & str,int id);

protected:
   virtual void resizeEvent(TQResizeEvent *event);
   virtual void timerEvent(TQTimerEvent *event);
   virtual void keyPressEvent(TQKeyEvent *event);
   virtual void keyReleaseEvent(TQKeyEvent *event);
   SConfig modifyConfig(SConfig conf);
   TQCanvasPixmapArray* loadOldPixmapSequence(const TQString& datapattern,
                           const TQString& maskpattern, int framecount=1);
   void moveShips();
   void moveBullets();
   void moveMines();
   void moveExplosions();
   void calculatePowerups();
   void collisions();
private:
   TDEActionCollection *actionCollection;

   TQCanvas field;
   TQCanvasView view;

   SConfig customConfig,config;

   int timerID;
   bool playerKeyPressed[2][PlayerKeyNum];
   bool bulletShot[2];
   bool minePut[2];
   bool waitForStart;
   double gameEnd;
   double timeToNextPowerup;

// sprites
   TQPtrList<TQImage> shipImages;
   TQPtrList<TQPoint> points;
   TQImage bulletImage;
   TQCanvasPixmapArray *bulletsequence[2];
   TQCanvasPixmapArray *shipsequence[2];
   TQCanvasPixmapArray *explosionsequence;
   TQCanvasPixmapArray *minesequence[2];
   TQCanvasPixmapArray *mineexplosionsequence;
   TQCanvasPixmapArray *powerupsequence[PowerupSprite::PowerupNum];


   ShipSprite *ship[2];
   SunSprite *sun;
   TQCanvasText *textSprite;
   TQPtrList<BulletSprite> *bullets[2];
   TQPtrList<MineSprite> *mines[2];
   TQPtrList<ExplosionSprite> explosions;
   TQPtrList<PowerupSprite> powerups;

   KRandomSequence random;

//Ai
   Ai *ai[2];

};

#endif
