#################################################
#
#  (C) 2017 Slávek Banko
#  slavek (DOT) banko (AT) axis.cz
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

if( WITH_GSTREAMER )
  pkg_search_module( GST gstreamer-1.0>=1.0.0 gstreamer-0.10>=0.10.0 gstreamer-0.8>=0.8.0 )
  if( NOT GST_FOUND )
    tde_message_fatal( "gstreamer is requested, but not found on your system" )
  endif( )
  set( HAVE_GSTREAMER 1 CACHE INTERNAL "" FORCE )
endif( WITH_GSTREAMER )


if( WITH_MUSICBRAINZ )
  check_include_file( tunepimp-0.5/tp_c.h HAVE_TUNEPIMP_H )
  if( NOT HAVE_TUNEPIMP_H )
    tde_message_fatal( "tunepimp is requested, but not found on your system" )
  endif( )
  check_library_exists( tunepimp tp_SetTRMCollisionThreshold "" HAVE_TUNEPIMP_5 )
  if( HAVE_TUNEPIMP_5 )
    tde_message_fatal( "tunepimp is requested, but found tunepimp5 that is not supported" )
  endif( )
  check_library_exists( tunepimp tp_SetFileNameEncoding "" HAVE_TUNEPIMP_4 )
  if( HAVE_TUNEPIMP_4 )
    set( HAVE_MUSICBRANINZ 4 CACHE INTERNAL "" FORCE )
  else( )
    set( HAVE_MUSICBRANINZ 1 CACHE INTERNAL "" FORCE )
  endif( )
  set( MUSICBRAINZ_LIBRARIES tunepimp )
else( WITH_MUSICBRAINZ )
  set( HAVE_MUSICBRANINZ 0 CACHE INTERNAL "" FORCE )
endif( WITH_MUSICBRAINZ )
