/***************************************************************************
    begin                : Fri Oct 18 2002
    copyright            : (C) 2002 - 2004 by Scott Wheeler
    email                : wheeler@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef STATUSLABEL_H
#define STATUSLABEL_H

#include "playlistinterface.h"

#include <tqhbox.h>

class TQLabel;
class KSqueezedTextLabel;

class FileHandle;

class StatusLabel : public TQHBox, public PlaylistObserver
{
    TQ_OBJECT
  

public:
    StatusLabel(PlaylistInterface *playlist, TQWidget *parent = 0, const char *name = 0);
    virtual ~StatusLabel();
    virtual void updateCurrent();

public slots:
    /**
     * This just sets internal variables that are used by setItemCurrentTime().
     * Please call that method to display the time.
     */      
    void setItemTotalTime(int time) { m_itemTotalTime = time; }
    void setItemCurrentTime(int time) { m_itemCurrentTime = time; updateTime(); }
    virtual void updateData();

signals:
    void jumpButtonClicked();

private:
    void updateTime();
    virtual bool eventFilter(TQObject *o, TQEvent *e);

    static TQString formatTime(int minutes, int seconds);

    int m_itemTotalTime;
    int m_itemCurrentTime;
    bool m_showTimeRemaining;

    KSqueezedTextLabel *m_playlistLabel;
    KSqueezedTextLabel *m_trackLabel;
    TQLabel *m_itemTimeLabel;
};

#endif
