/**************************************************************************

    midicfgdlg.cpp  - The midi config dialog  
    Copyright (C) 1997,98  Antonio Larrosa Jimenez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    Send comments and bug fixes to larrosa@kde.org
    or to Antonio Larrosa, Rio Arnoya, 10 5B, 29006 Malaga, Spain

***************************************************************************/
#include <tqpushbutton.h>
#include <tqlistbox.h>
#include <tqlabel.h> 
#include <tqlayout.h>

#include <tdeapplication.h>
#include <tdefiledialog.h>
#include <tdemessagebox.h>
#include <tdelocale.h>
#include <libtdemid/deviceman.h>

#include "midicfgdlg.h"
#include "version.h"
#include <tdeglobal.h>
#include <kstandarddirs.h>

MidiConfigDialog::MidiConfigDialog(DeviceManager *dm,
    TQWidget *parent,const char *name) : KDialogBase(parent,name,true,
      i18n("Configure MIDI Devices"), KDialogBase::Ok|KDialogBase::Cancel)
{
  setMinimumSize(360,240);
  TQWidget *page = new TQWidget( this );
  setMainWidget(page);

  TQVBoxLayout *topLayout=new TQVBoxLayout(page, 0, spacingHint());
  TQLabel *label=new TQLabel(i18n("Select the MIDI device you want to use:"),page);
  topLayout->addWidget(label);
  mididevices=new TQListBox(page,"midideviceslist");
  topLayout->addWidget(mididevices,3);
  connect(mididevices,TQ_SIGNAL(highlighted(int)),TQ_SLOT(deviceselected(int)));
  devman=dm;
  TQString temp;
  for (int i=0;i<devman->midiPorts()+devman->synthDevices();i++)
  {
    if (strcmp(devman->type(i),"")!=0)    
      temp = TQString("%1 - %2").arg(devman->name(i)).arg(devman->type(i));
    else
      temp = devman->name(i);

    mididevices->insertItem(temp,i);
  };
  selecteddevice=devman->defaultDevice();
  mididevices->setCurrentItem(selecteddevice);

  TQLabel *label2=new TQLabel(i18n("Use the MIDI map:"),page);
  topLayout->addWidget(label2);


  if (selectedmap!=NULL) delete selectedmap;
  if (strcmp(devman->midiMapFilename(),"")==0)
    selectedmap=NULL;
  else
  {
    selectedmap=new char[strlen(devman->midiMapFilename())+1];
    strcpy(selectedmap,devman->midiMapFilename());
  }

  if (selectedmap!=NULL) maplabel=new TQLabel(selectedmap,page);
  else maplabel=new TQLabel(i18n("None"),page);

  topLayout->addWidget(maplabel);

  TQHBoxLayout *hbox=new TQHBoxLayout(topLayout);
  hbox->addStretch(1);
  mapbrowse=new TQPushButton(i18n("Browse..."),page);
  hbox->addWidget(mapbrowse);
  connect(mapbrowse,TQ_SIGNAL(clicked()),TQ_SLOT(browseMap()) );

  mapnone=new TQPushButton(i18n("None"),page);
  hbox->addWidget(mapnone);
  connect(mapnone,TQ_SIGNAL(clicked()),TQ_SLOT(noMap()) );

  topLayout->addStretch(1);

}

void MidiConfigDialog::deviceselected(int idx)
{
  selecteddevice=idx;
}

void MidiConfigDialog::browseMap()
{
  TQString path = TDEGlobal::dirs()->findAllResources("appdata", "maps/*.map").last();
  path.truncate(path.findRev('/'));
  
  KURL url = KFileDialog::getOpenURL(path,"*.map",this); 
  
  if( url.isEmpty() )
    return;

  if( !url.isLocalFile() )
  {
    KMessageBox::sorry( 0L, i18n( "Only local files are currently supported." ) );
    return;
  }

  TQString filename = url.path();

  delete selectedmap;
  selectedmap=new char[filename.length()+1];
  strcpy(selectedmap,TQFile::encodeName(filename));
  maplabel->setText(selectedmap);
}

void MidiConfigDialog::noMap()
{
  if (selectedmap!=NULL) {delete selectedmap;selectedmap=NULL;}; 
  maplabel->setText(i18n("None"));
}

int MidiConfigDialog::selecteddevice=0;
char *MidiConfigDialog::selectedmap=NULL;

#include "midicfgdlg.moc"
