/*
 * KMix -- KDE's full featured mini mixer
 *
 *
 * Copyright (C) 2000 Stefan Schimanski <1Stein@gmx.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KMIX_H
#define KMIX_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for TQt
#include <tqstring.h>
#include <tqmap.h>

class TQHBox;
class TQWidgetStack;

// include files for KDE
#include <tdemainwindow.h>

class TDEAccel;
class TDEGlobalAccel;
class KComboBox;
class KMixerWidget;
class KMixDockWidget;
class KMixWindow;
class Mixer;

#include "mixer.h"
#include "mixdevicewidget.h"
#include "kmixIface.h"


class 
KMixWindow : public TDEMainWindow, virtual public KMixIface
{
   TQ_OBJECT

  public:
   KMixWindow();
   ~KMixWindow();

   // Additional functions for DCOP interface
   void setVolume(int percentage);
   void increaseVolume(int percentage);
   void decreaseVolume(int percentage);
   int  volume();

   void setAbsoluteVolume(long absoluteVolume);
   long absoluteVolume();
   long absoluteVolumeMin();
   long absoluteVolumeMax();

   void setMute(bool on);
   void toggleMute();
   bool mute();

   TQString mixerName();
   int deviceIndex();

   void setBalance(int balance);

  protected slots:
   void saveSettings();

  protected:
   void saveConfig();
   void loadConfig();

   void initActions();
   void initWidgets();
   void initMixerWidgets();

   void updateDocking();

   bool queryClose();
   void showEvent( TQShowEvent * );
   void hideEvent( TQHideEvent * );

  public slots:
   void quit();
   void showSettings();
   void showHelp();
   void showAbout();
   void toggleMenuBar();
   //void loadVolumes();
   void saveVolumes();
   virtual void applyPrefs();
   void stopVisibilityUpdates();

  private:
   TDEAccel *m_keyAccel;
   TDEGlobalAccel *m_globalAccel;
   TQPopupMenu *m_fileMenu;
   TQPopupMenu *m_viewMenu;
   TQPopupMenu *m_helpMenu;

   bool m_volumeWidget;
   bool m_onLogin;
   bool m_isVisible;
   bool m_visibilityUpdateAllowed;
   TQt::Orientation m_toplevelOrientation;

   TQPtrList<KMixerWidget> m_mixerWidgets;

   TQHBox* mixerNameLayout;
   KComboBox *m_cMixer;
   TQWidgetStack *m_wsMixers;
   KMixDockWidget *m_dockWidget;
   TQString m_hwInfoString;
   TQVBoxLayout *widgetsLayout;

  private slots:
   //void removeMixerWidget( KMixerWidget *mw );
   void slotHWInfo();
   void showSelectedMixer( int mixer );
   void configureGlobalShortcuts();
   void slotToggleMuted() { toggleMute(); }
   void slotIncreaseVolume() { increaseVolume(5); }
   void slotDecreaseVolume() { decreaseVolume(5); }
};

#endif // KMIX_H
