/*
  Copyright (C) 2002 Rik Hemsley (rikkus) <rik@kde.org>
  Copyright (C) 2002 Benjamin Meyer <ben-devel@meyerhome.net>
  Copyright (C) 2003 Richard Lärkäng <nouseforaname@home.se>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <tqlayout.h>
#include <tqcheckbox.h>
#include <tqcombobox.h>
#include <tqspinbox.h>
#include <tqlineedit.h>
#include <tqradiobutton.h>
#include <tqlistbox.h>
#include <tqlabel.h>
#include <tqbuttongroup.h>
#include <tqtabwidget.h>

#include <tdeconfig.h>
#include <tdelocale.h>
#include <tdeglobal.h>
#include <kgenericfactory.h>
#include <tdemessagebox.h>
#include <tdeconfigdialogmanager.h>

#include "cddbconfigwidget.h"

#include "kcmcddb.h"
#include "libkcddb/lookup.h"
#include "libkcddb/cache.h"
#include "libkcddb/submit.h"

typedef KGenericFactory<CDDBModule, TQWidget> KCDDBFactory;
K_EXPORT_COMPONENT_FACTORY ( kcm_cddb, KCDDBFactory( "kcmcddb" ) )

CDDBModule::CDDBModule(TQWidget *parent, const char *name, const TQStringList &)
  : TDECModule(parent, name)
{
  TDEGlobal::locale()->insertCatalogue("libkcddb");
  setButtons(Default | Apply | Help);

  widget_ = new CDDBConfigWidget(this);

  KCDDB::Config* cfg = new KCDDB::Config();
  cfg->readConfig();

  addConfig(cfg, widget_);

  TQVBoxLayout * layout = new TQVBoxLayout(this, 0);

  layout->addWidget(widget_);
  layout->addStretch();

  setQuickHelp(i18n("CDDB is used to get information like artist, title and song-names in CD's"));

  load();
}

  void
CDDBModule::defaults()
{
  TDECModule::defaults();

  updateWidgetsFromConfig(KCDDB::Config());
}

  void
CDDBModule::checkSettings() const
{
  KCDDB::Config config;

  config.readConfig();

  if (config.smtpHostname().isEmpty() || config.emailAddress().isEmpty()
      || !config.emailAddress().contains("@") ||
      (!config.replyTo().isEmpty() && !config.replyTo().contains("@")))
      
  {
    if (config.submitTransport() == KCDDB::Submit::SMTP)
    {
      KMessageBox::sorry(widget_, i18n("freedb has been set to use HTTP for submissions "
                                    "because the email details you have entered are "
                                    "incomplete. Please review your email settings "
                                    "and try again."), i18n("Incorrect Email Settings"));
      config.setSubmitTransport(KCDDB::Submit::HTTP);

      config.writeConfig();
    }
  }
}

  void
CDDBModule::updateWidgetsFromConfig(const KCDDB::Config & config)
{
  bool smtpUserIsEmpty = config.smtpUsername().isEmpty();
  widget_->needsAuthenticationBox->setChecked(!smtpUserIsEmpty);
  widget_->kcfg_smtpUsername->setEnabled(!smtpUserIsEmpty);
}

  void
CDDBModule::save()
{
  TDECModule::save();

  checkSettings();
}

  void
CDDBModule::load()
{
  TDECModule::load();

  KCDDB::Config config;
  config.readConfig();
  updateWidgetsFromConfig(config);
}

TQString CDDBModule::handbookSection() const
{
 	int index = widget_->tabWidget2->currentPageIndex();
 	if (index == 0)
		return "cddb-lookup";
	else if (index == 1)
		return "cddb-submit";
 	else
 		return TQString::null;
}
#include "kcmcddb.moc"
