/*
  Copyright (C) 2002 Rik Hemsley (rikkus) <rik@kde.org>
  Copyright (C) 2002 Benjamin Meyer <ben-devel@meyerhome.net>
  CopyRight (C) 2002 Nadeem Hasan <nhasan@kde.org>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
*/

#ifndef KCDDB_LOOKUP_H
#define KCDDB_LOOKUP_H

#include "cddb.h"
#include "cdinfo.h"
#include <tqobject.h>

namespace KCDDB
{
  typedef TQPair<TQString, TQString> CDDBMatch;
  typedef TQValueList<CDDBMatch> CDDBMatchList;

  class Lookup : public CDDB, public TQObject
  {
    public:

      enum Transport
      {
        CDDBP,
        HTTP
      };


      Lookup();
      virtual ~Lookup();

      virtual Result lookup( const TQString &, uint, const TrackOffsetList & ) = 0;

      CDInfoList lookupResponse() const;

    protected:

      void parseExtraMatch(  const TQString & );
      Result parseQuery(  const TQString & );
      Result parseRead(  const TQString & );

      CDInfoList cdInfoList_;
      CDDBMatchList matchList_;
      TQString category_;
  };
}

#endif // KCDDB_LOOKUP_H
