/*
   This file is part of KDE/aRts (Noatun) - xine integration
   Copyright (C) 2002 Ewald Snel <ewald@rambo.its.tudelft.nl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
*/

#ifndef __USERINTERFACE_H
#define __USERINTERFACE_H

#include <noatun/controls.h>
#include <noatun/plugin.h>
#include <noatun/video.h>
#include <tdeaction.h>
#include <tdemainwindow.h>
#include <kmedia2.h>
#include <tqevent.h>
#include <tqlabel.h>
#include <tqpopupmenu.h>
#include <tqpushbutton.h>
#include <tqvbox.h>
#include "propertiesdialog.h"


class SimpleUI : public TDEMainWindow, public UserInterface
{
    TQ_OBJECT
  

public:
    SimpleUI();
    ~SimpleUI();

protected:
    void setupActions();
    void setupCentralWidget();

    virtual void closeEvent( TQCloseEvent * );
    virtual void dragEnterEvent( TQDragEnterEvent *event );
    virtual void dropEvent( TQDropEvent *event );

public slots:
    void slotAdaptSize( int width, int height );
    void slotPlaying();
    void slotStopped();
    void slotPaused();
    void slotTimeout();
    void slotSkipTo( int sec );
    void slotChanged();
    void slotContextMenu( const TQPoint &pos );

private slots:
    void slotSliderMoved( int sec );
    void slotVolumeSliderMoved( int volume );
    void slotVolumeFrame();
    void slotVolumeChanged( int volume );
    void showMenubar();
    void showStatusbar();

private:
    PropertiesDialog *propertiesDialog;
    TQPopupMenu *contextMenu;
    TQPushButton *stopButton;
    TQPushButton *playButton;
    TQPushButton *volumeButton;
    TQVBox *volumeFrame;
    TQLabel *volumeLabel;
    TQLabel *positionLabel;
    VideoFrame *video;
    L33tSlider *volumeSlider;
    L33tSlider *slider;
    int extra_width;
    int extra_height;
    TDEToggleAction *menubarAction;
    TDEToggleAction *statusbarAction;
};

#endif
