/*
	smpppdclient.h
 
	Copyright (c) 2006      by Heiko Schaefer        <heiko@rangun.de>
 
	Kopete    (c) 2002-2006 by the Kopete developers <kopete-devel@kde.org>
 
	*************************************************************************
	*                                                                       *
	* This program is free software; you can redistribute it and/or modify  *
	* it under the terms of the GNU General Public License as published by  *
	* the Free Software Foundation; version 2 of the License.               *
	*                                                                       *
	*************************************************************************
*/

#ifndef SMPPPDCLIENT_H
#define SMPPPDCLIENT_H

#include <tqstringlist.h>

namespace KNetwork {
class KStreamSocket;
};

namespace SMPPPD {

class State;

/**
	@author Heiko Schaefer <heiko@rangun.de>
*/
class Client {
    Client(const Client&);
    Client& operator=(const Client&);

public:
    Client();
    ~Client();

    bool isReady() const;

    bool connect(const TQString& server, uint port = 3185);
    void disconnect();

    TQStringList getInterfaceConfigurations();
    bool statusInterface(const TQString& ifcfg);

    bool isOnline();
    TQString serverID() const;
    TQString serverVersion() const;

    void setPassword(const TQString& password);

private:
    friend class State;

    void changeState(State * newState);
    TQStringList read() const;
    void write(const char * cmd);

private:
    State * m_state;
    KNetwork::KStreamSocket * m_sock;
    TQString m_serverID;
    TQString m_serverVer;
    TQString m_password;
};

inline void Client::changeState(State * newState) {
    m_state = newState;
}

inline void Client::setPassword(const TQString& password) {
    m_password = password;
}

};

#endif
