
/***************************************************************************
                   jabberconnector.cpp  -  Socket Connector for Jabber
                             -------------------
    begin                : Wed Jul 7 2004
    copyright            : (C) 2004 by Till Gerken <till@tantalo.net>

			   Kopete (C) 2004 Kopete developers <kopete-devel@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation; either version 2.1 of the  *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#include <kdebug.h>
#include "jabberconnector.h"
#include "jabberbytestream.h"
#include "jabberprotocol.h"

JabberConnector::JabberConnector ( TQObject *parent, const char */*name*/ )
 : XMPP::Connector ( parent )
{
	kdDebug ( JABBER_DEBUG_GLOBAL ) << k_funcinfo << "New Jabber connector." << endl;

	mErrorCode = KNetwork::TDESocketBase::NoError;

	mByteStream = new JabberByteStream ( this );
	mSrvResolver = new SrvResolver;

	connect ( mByteStream, TQ_SIGNAL ( connected () ), this, TQ_SLOT ( slotConnected () ) );
	connect ( mByteStream, TQ_SIGNAL ( error ( int ) ), this, TQ_SLOT ( slotError ( int ) ) );
	connect ( mSrvResolver, TQ_SIGNAL( resultsReady() ), this, TQ_SLOT( slotSrvLookup() ) );
}

JabberConnector::~JabberConnector ()
{
	delete mByteStream;
	delete mSrvResolver;
}

void JabberConnector::connectToServer ( const TQString &server )
{
	kdDebug ( JABBER_DEBUG_GLOBAL ) << k_funcinfo << "Initiating connection to " << server << endl;

	mServer = server;
	mErrorCode = KNetwork::TDESocketBase::NoError;

	if( mHost.isEmpty() ) {
		mSrvResolver->resolve(server, "xmpp-client", "tcp");
		return;
	}

	if ( !mByteStream->connect ( mHost, TQString::number ( mPort ) ) )
	{
		// Houston, we have a problem
		mErrorCode = mByteStream->socket()->error ();
		emit error ();
	}

}

void JabberConnector::slotConnected ()
{
	kdDebug ( JABBER_DEBUG_GLOBAL ) << k_funcinfo << "We are connected." << endl;

	// FIXME: setPeerAddress() is something different, find out correct usage later
	//KInetSocketAddress inetAddress = mStreamSocket->address().asInet().makeIPv6 ();
	//setPeerAddress ( TQHostAddress ( inetAddress.ipAddress().addr () ), inetAddress.port () );

	emit connected ();

}

void JabberConnector::slotError ( int code )
{
	kdDebug ( JABBER_DEBUG_GLOBAL ) << k_funcinfo << "Error detected: " << code << endl;

	mErrorCode = code;
	emit error ();

}

void JabberConnector::slotSrvLookup()
{
	if( mSrvResolver->failed() ) {
		if( mErrorCode == KNetwork::TDESocketBase::NoError ) {
			// SRV records probably not exist - try server and default port as fallback
			if ( !mByteStream->connect ( mServer, TQString::number ( 5222 ) )) {
				mErrorCode = mByteStream->socket()->error ();
			}
		}
		if( mErrorCode != KNetwork::TDESocketBase::NoError ) {
			emit error ();
		}
		return;
	}

	if( !mByteStream->connect( mSrvResolver->resultAddress().toString(), TQString::number( mSrvResolver->resultPort() ))) {
		mErrorCode = mByteStream->socket()->error ();
		mSrvResolver->next();
	}
}

int JabberConnector::errorCode ()
{

	return mErrorCode;

}

ByteStream *JabberConnector::stream () const
{

	return mByteStream;

}

void JabberConnector::done ()
{

	mByteStream->close ();

}

void JabberConnector::setOptHostPort ( const TQString &host, TQ_UINT16 port )
{
	kdDebug ( JABBER_DEBUG_GLOBAL ) << k_funcinfo << "Manually specifying host " << host << " and port " << port << endl;

	mHost = host;
	mPort = port;

}

void JabberConnector::setOptSSL ( bool ssl )
{
	kdDebug ( JABBER_DEBUG_GLOBAL ) << k_funcinfo << "Setting SSL to " << ssl << endl;

	setUseSSL ( ssl );

}

void JabberConnector::setOptProbe ( bool )
{
	// FIXME: Implement this.
}

#include "jabberconnector.moc"
