/*
    Kopete Oscar Protocol
    oscartypeclasses.h - Oscar Type Definitions

    Copyright (c) 2004 Matt Rogers <mattr@kde.org>
    Copyright (c) 2004 Gustavo Pichorim Boiko <gustavo.boiko@kdemail.net>

    Kopete (c) 2002-2004 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef _OSCARTYPECLASSES_H_
#define _OSCARTYPECLASSES_H_

#include <tqglobal.h>
#include <tqstring.h>
#include <tqcstring.h>
#include <tqvaluelist.h>
#include "kopete_export.h"

namespace Oscar
{
class KOPETE_EXPORT TLV
{
public:

	TLV();
	TLV( TQ_UINT16, TQ_UINT16, char* data );
	TLV( TQ_UINT16, TQ_UINT16, const TQByteArray& );
	TLV( const TLV& t );

	operator bool() const;

	TQ_UINT16 type;
	TQ_UINT16 length;
	TQByteArray data;

};

class KOPETE_EXPORT SSI
{
public:
	SSI();
	SSI( const TQString &name, int gid, int bid, int type, const TQValueList<TLV>& tlvlist, int tlvLength = 0 );
	SSI( const SSI& other );

	/** Get the validity of this item */
	bool isValid() const;

	/** \brief The name of this SSI item.
	 * This is usually the screenname, ICQ number, or group name. */
	TQString name() const;

	/** \brief The group id of the SSI item */
	TQ_UINT16 gid() const;

	/** \brief The buddy id of the SSI item */
	TQ_UINT16 bid() const;

	/**
	 * \brief The type of the SSI Item.
	 * see ROSTER_* defines on oscartypes.h
	 * Use a value of 0xFFFF for an SSI item not on the server list
	 */
	TQ_UINT16 type() const;

	/** \brief the TLV list for the item */
	const TQValueList<TLV>& tlvList() const;

	/** \brief Set the TLV list for the item */
	void setTLVList( TQValueList<TLV> );

	/**
	 * \brief Set the length of the TLV list
	 *
	 * This is not the number of items in the list!! It's the aggregation of the
	 * sizes of the TLVs
	 */
	void setTLVListLength( TQ_UINT16 newLength );

	/** \brief Get the TLV list length */
	TQ_UINT16 tlvListLength() const;

	/**
	 * Get the alias for the SSI item
	 * This is TLV 0x0131 in an SSI item
	 */
	TQString alias() const;

	/**
	 * Set the alias for the SSI item
	 * This should be done after a successful modification of the item
	 * on the server
	 */
	void setAlias( const TQString& newAlias );

	/** \brief Indicates we're awaiting authorization from this item */
	bool waitingAuth() const;

	/** Set whether we are waiting authorization or not from this item */
	void setWaitingAuth( bool waiting );

	void setIconHash( TQByteArray hash );

	TQByteArray iconHash() const;

	/** \brief String representation of our SSI object */
	TQString toString() const;

	bool operator==( const SSI& item ) const;
	operator bool() const;

	operator TQByteArray() const;

	void refreshTLVLength();

	//! parse the TLVs checking for aliases and auth and stuff like that
	void checkTLVs();

private:
	TQString m_name;
	int m_gid;
	int m_bid;
	int m_type;
	TQValueList<TLV> m_tlvList;
	int m_tlvLength;
	bool m_waitingAuth;
	TQString m_alias;
	TQByteArray m_hash;
};

}
#endif
