/*
    Kopete Yahoo Protocol
    Notifies about status changes of buddies

    Copyright (c) 2005 André Duffeck <duffeck@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef STATUSNOTIFIERTASK_H
#define STATUSNOTIFIERTASK_H

#include "task.h"
#include "yahootypes.h"

class TQString;
class YMSGTransfer;

/**
@author André Duffeck
*/
class StatusNotifierTask : public Task
{
TQ_OBJECT
  
public:
	StatusNotifierTask(Task *parent);
	~StatusNotifierTask();
	
	bool take(Transfer *transfer);

protected:
	virtual bool forMe( const Transfer *transfer ) const;
	void parsetStatus( YMSGTransfer *transfer );
	void parseStealthStatus( YMSGTransfer *transfer );
	void parseAuthorization( YMSGTransfer *transfer );
signals:
	void statusChanged( const TQString &nick, int state, const TQString &message, int away, int idle, int pictureChecksum );
	void stealthStatusChanged( const TQString&, Yahoo::StealthStatus );
	void loginResponse( int, const TQString& );
	void authorizationAccepted( const TQString & );
	void authorizationRejected( const TQString &, const TQString & );
	void gotAuthorizationRequest( const TQString &, const TQString &, const TQString & );
};

#endif
