/***************************************************************************
                            krdc.h  -  main window
                              -------------------
    begin                : Tue May 13 23:10:42 CET 2002
    copyright            : (C) 2002-2003 by Tim Jansen
    email                : tim@tjansen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRDC_H
#define KRDC_H

#include <kprogress.h>
#include <tqscrollview.h>
#include <tqlayout.h>
#include <tqsize.h>
#include <tqrect.h>
#include <tqtimer.h>
#include <tqdesktopwidget.h>

#include "vnc/kvncview.h"
#include "rdp/krdpview.h"
#include "kfullscreenpanel.h"
#include "vidmode.h"
#include "smartptr.h"
#include "keycapturedialog.h"

class TQPixmap;
class TDEToolBar;
class TQPopupMenu;
class TQDockArea;

enum WindowMode {
	WINDOW_MODE_AUTO,
	WINDOW_MODE_NORMAL,
	WINDOW_MODE_FULLSCREEN
};

// known protocols
enum Protocol {
	PROTOCOL_AUTO,
	PROTOCOL_VNC,
	PROTOCOL_RDP
};

// Overloaded TQScrollView, to let mouse move events through to remote widget
class TQScrollView2 : public TQScrollView {
public:
	TQScrollView2(TQWidget *w, const char *name);
protected:
	virtual void mouseMoveEvent(TQMouseEvent *e);
};


class KRDC : public TQWidget
{
	TQ_OBJECT
  
private:
	SmartPtr<KProgressDialog> m_progressDialog; // dialog, displayed while connecting
	TQVBoxLayout *m_layout;     // the layout for autosizing the scrollview
	TQScrollView *m_scrollView; // scrollview that contains the remote widget
	KProgress *m_progress;             // progress bar for the dialog
	KRemoteView *m_view;                  // the remote widget (e.g. KVncView)

	SmartPtr<KeyCaptureDialog> m_keyCaptureDialog; // dialog for key capturing
	KFullscreenPanel *m_fsToolbar;     // toolbar for fullscreen (0 in normal mode)
	TQWidget *m_fsToolbarWidget;        // qt designer widget for fs toolbar
                                           //     (invalid in normal mode)
	TQPixmap m_pinup, m_pindown;        // fs toolbar imaged for autohide button
	TDEToolBar *m_toolbar;               // toolbar in normal mode (0 in fs mode)
	TQDockArea *m_dockArea;             // dock area for toolbar in normal mode (0 in fs mode)
	TQPopupMenu *m_popup;               // advanced options popup (0 in fs mode)
	TQDesktopWidget m_desktopWidget;

	static const int TOOLBAR_AUTOHIDE_TIMEOUT;
	bool m_ftAutoHide; // if true auto hide in fs is activated
	TQTimer m_autoHideTimer; // timer for autohide

	TQTimer m_bumpScrollTimer; // timer for bump scrolling (in fs, when res too large)

	bool m_showProgress; // can disable showing the progress dialog temporary
	TQString m_host;      // host string as given from user
	Protocol m_protocol; // the used protocol
	Quality m_quality;   // current quality setting
	TQString m_encodings; // string containing the encodings, space separated,
	                     // used for config before connection
	TQString m_password;  // if not null, contains the password to use
	TQString m_resolution;// contains an alternative resolution
	TQString m_keymap;    // keymap on the terminal server

	WindowMode m_isFullscreen;    // fs/normal state
	Resolution m_oldResolution;   // conatins encoded res before fs
	bool m_fullscreenMinimized;   // true if window is currently minimized from fs
	TQSize m_fullscreenResolution; // xvidmode size (valid only in fs)
	bool m_windowScaling;         // used in startup and fullscreen to determine
	                              // whether scaling should be enabled in norm mode.
	                              // The current state is m_view->scaled().
	bool m_localCursor;           // show local cursor no matter what
	TQSize m_initialWindowSize;    // initial window size (windowed mode only),
	                              // invalid after first use
	static TQString m_lastHost; // remembers last value of host input

	bool parseHost(TQString &s, Protocol &prot, TQString &serverHost, int &serverPort,
	               TQString &userName, TQString &password);

	void repositionView(bool fullscreen);

	void showProgressDialog();
	void hideProgressDialog();

	static const int TOOLBAR_FPS_1000;
	static const int TOOLBAR_SPEED_DOWN;
	static const int TOOLBAR_SPEED_UP;
	void fsToolbarScheduleHidden();
	TQPopupMenu *createPopupMenu(TQWidget *parent) const;

protected:
	virtual void mouseMoveEvent(TQMouseEvent *e);
	virtual bool event(TQEvent *e);
	virtual bool eventFilter(TQObject *watched, TQEvent *e);
	virtual TQSize sizeHint();

public:
	KRDC(WindowMode wm = WINDOW_MODE_AUTO,
	     const TQString &host = TQString(),
	     Quality q = QUALITY_UNKNOWN,
	     const TQString &encodings = TQString(),
	     const TQString &password = TQString(),
	     bool scale = false,
	     bool localCursor = false,
	     TQSize initialWindowSize = TQSize());
	~KRDC();

	bool start();

	static void setLastHost(const TQString &host);

private slots:
	void changeProgress(RemoteViewStatus s);
	void showingPasswordDialog(bool b);
	void showProgressTimeout();

	void setSize(int w, int h);
	void iconify();
	void toolbarChanged();
	void bumpScroll();

	void toggleFsToolbarAutoHide();
	void setFsToolbarAutoHide(bool on);
	void showFullscreenToolbar();
	void hideFullscreenToolbarDelayed();
	void hideFullscreenToolbarNow();

public slots:
	void quit();
	void enableFullscreen(bool full = false);
	void paste();
	void switchToNormal(bool scaling = false);
	void switchToFullscreen(bool scaling = false);
	void viewOnlyToggled();
	void showLocalCursorToggled();

signals:
        void disconnected();
	void disconnectedError();
};

#endif
