#ifndef __mditoplevel_h__
#define __mditoplevel_h__

#include <tqptrlist.h>
#include <tqtabwidget.h>

#include <tdemainwindow.h>

class KSTabWidget : public TQTabWidget
{
    TQ_OBJECT
  
public:
    KSTabWidget ( TQWidget * parent = 0, const char * name = 0, WFlags f = 0 )
	: TQTabWidget(parent, name, f)
    {
    }

protected:
    virtual void mousePressEvent(TQMouseEvent *e);

signals:
    void showContexMenu(TQWidget *, const TQPoint &);

};

class TQLabel;
class TDEPopupMenu;

class MDITopLevel : public TDEMainWindow
{
    TQ_OBJECT
  
public:
    MDITopLevel(TQWidget *parent = 0, const char *name = 0);
    virtual ~MDITopLevel();

    void addWidget( TQWidget *widget, bool show );

    void removeWidget( TQWidget *widget );

    TQTabWidget *tabWidget() const { return m_tab; }
	void next();
	void previous();

    TQPtrList<TQWidget> &widgets() { return m_tabWidgets; }

    void hideWidget( TQWidget *widget );
    void showWidget( TQWidget *widget );

    virtual bool eventFilter( TQObject *obj, TQEvent *ev );
    bool closing() const { return m_closing; }

protected:
    void removeFromAddressedList( const TQWidget* w );
    virtual void closeEvent( TQCloseEvent *ev );

private slots:
    void slotWidgetDestroyed();
    void slotCurrentChanged( TQWidget *page );
    void slotMarkPageDirty( bool );
    void slotChangeChannelName( const TQString &, const TQString &newName );
    void slotShowContexMenu(TQWidget *, const TQPoint &);
    void slotCloseLastWid();

private:
    KSTabWidget *m_tab;
    TDEPopupMenu *m_pop;
    TQWidget *m_last_pop_wid;
    TQPtrList<TQWidget> m_tabWidgets;
    TQPtrList<TQWidget> m_addressed;
    TQPixmap m_dirtyIcon;
    TQPixmap m_addressedIcon;
    bool m_closing;
};

#endif
