/***************************************************************************
                       hostpreferences.cpp  -  per host preferences
                             -------------------
    begin                : Fri May 09 22:33 CET 2003
    copyright            : (C) 2003 by Tim Jansen
                         : (C) 2004 Nadeem Hasan <nhasan@kde.org>
    email                : tim@tjansen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "hostpreferences.h"
#include "vnc/vnchostpref.h"
#include "rdp/rdphostpref.h"

#include <tdeapplication.h>
#include <tdeconfig.h>
#include <kstaticdeleter.h>

#include <tqregexp.h>
#include <tqmap.h>

HostPreferences *HostPreferences::m_instance = 0;
static KStaticDeleter<HostPreferences> sd;

HostPreferences *HostPreferences::instance()
{
	if ( m_instance == 0 )
		sd.setObject( m_instance, new HostPreferences() );

	return m_instance;
}

HostPref::HostPref(TDEConfig *conf, const TQString &host, const TQString &type) :
	m_host(host),
	m_type(type),
	m_config(conf) {
}

HostPref::~HostPref() {
	m_config->sync();
}

TQString HostPref::host() const {
	return m_host;
}

TQString HostPref::type() const {
	return m_type;
}

TQString HostPref::prefix() const {
	return prefix(m_host, m_type);
}

TQString HostPref::prefix(const TQString &host, const TQString &type) {
	return TQString("PerHost-%1-%2-").arg(type).arg(host);
}


HostPreferences::HostPreferences() {
	m_config = kapp->config();
}

HostPreferences::~HostPreferences() {
  if ( m_instance == this )
    sd.setObject( m_instance, 0, false );
}

HostPrefPtr HostPreferences::getHostPref(const TQString &host, const TQString &type) {
	m_config->setGroup("PerHostSettings");
	if (!m_config->readBoolEntry(HostPref::prefix(host, type)+"exists"))
		return 0;

	if (type == VncHostPref::VncType) {
		HostPrefPtr hp = new VncHostPref(m_config, host, type);
		hp->load();
		return hp;
	}
	else if(type == RdpHostPref::RdpType) {
		HostPrefPtr hp = new RdpHostPref(m_config, host, type);
		hp->load();
		return hp;
	}
	Q_ASSERT(true);
	return 0;
}

HostPrefPtr HostPreferences::createHostPref(const TQString &host, const TQString &type) {
	HostPrefPtr hp = getHostPref(host, type);
	if (hp)
		return hp;

	if(type == VncHostPref::VncType)
	{
		hp = new VncHostPref(m_config, host, type);
	}
	else if(type == RdpHostPref::RdpType)
	{
		hp = new RdpHostPref(m_config, host, type);
	}
	hp->setDefaults();
	return hp;
}

HostPrefPtr HostPreferences::vncDefaults()
{
	HostPrefPtr hp = new VncHostPref( m_config );
	hp->load();

	return hp;
}

HostPrefPtr HostPreferences::rdpDefaults()
{
	HostPrefPtr hp = new RdpHostPref( m_config );
	hp->load();

	return hp;
}

HostPrefPtrList HostPreferences::getAllHostPrefs() {
	HostPrefPtrList r;
	TQMap<TQString, TQString> map = m_config->entryMap("PerHostSettings");
	TQStringList keys = map.keys();
	TQStringList::iterator it = keys.begin();
	while (it != keys.end()) {
		TQString key = *it;
		if (key.endsWith("-exists")) {
			TQRegExp re("PerHost-([^-]+)-(.*)-exists");
			if (re.exactMatch(key)) {
				HostPrefPtr hp = getHostPref(re.cap(2), re.cap(1));
				if (hp)
					r += hp;
			}
			
		}
		it++;
	}
	return r;
}

void HostPreferences::removeHostPref(HostPref *hostPref) {
	hostPref->remove();
}

void HostPreferences::setShowBrowsingPanel( bool b )
{
	m_config->setGroup( TQString() );
	m_config->writeEntry( "browsingPanel", b );
}

void HostPreferences::setServerCompletions( const TQStringList &list )
{
	m_config->setGroup( TQString() );
	m_config->writeEntry( "serverCompletions", list );
}

void HostPreferences::setServerHistory( const TQStringList &list )
{
	m_config->setGroup( TQString() );
	m_config->writeEntry( "serverHistory", list );
}

bool HostPreferences::showBrowsingPanel()
{
	m_config->setGroup( TQString() );
	return m_config->readBoolEntry( "browsingPanel" );
}

TQStringList HostPreferences::serverCompletions()
{
	m_config->setGroup( TQString() );
	return m_config->readListEntry( "serverCompletions" );
}

TQStringList HostPreferences::serverHistory()
{
	m_config->setGroup( TQString() );
	return m_config->readListEntry( "serverHistory" );
}

void HostPreferences::sync() {
	m_config->sync();
}
