/***************************************************************************
 *
 * tdenetman-wireless_network.h - A NetworkManager frontend for TDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef TDENETWORKMANAGER_WIRELESS_NETWORK_H
#define TDENETWORKMANAGER_WIRELESS_NETWORK_H

#include "tdenetman.h"

#include <stdint.h>

#include <tdehardwaredevices.h>
#include <tdenetworkconnections.h>

class TDENetworkManager;
class WirelessNetworkPrivate;

/*
	A wireless network represents multiple accesspoints
	that share the same essid and security-caps
*/
class WirelessNetwork
{
	public:
		// bitwise encoded enum
		// allows the specification on how multiple APs get grouped together
		enum MATCH_ATTRIBUTES
		{
			// only match APs with the same ssid
			MATCH_SSID = 1
		};

		WirelessNetwork(const WirelessNetwork& other);
		WirelessNetwork (TQ_UINT32 match = MATCH_SSID);
		~WirelessNetwork ();

		WirelessNetwork& operator= (const WirelessNetwork&);

		// check if the AccessPoint represents the same net
		bool contains(const TDEMACAddress);

		// add an AP to the Network
		bool addAP(const TDEMACAddress, const TQString);

		// combined flags of all APs
		TDENetworkWiFiAPFlags::TDENetworkWiFiAPFlags   getFlags() const;

		// combined wpa-flags of all APs
		TDENetworkWiFiAPFlags::TDENetworkWiFiAPFlags   getWpaFlags() const;

		// combined rsn-flags of all APs
		TDENetworkWiFiAPFlags::TDENetworkWiFiAPFlags   getRsnFlags() const;

		// ssid of all APs
		const TQByteArray getSsid() const; 

		TQString    getDisplaySsid() const;
		bool       isEncrypted() const;

		// strength of the best AP
		TQ_UINT8    getStrength() const;

		// number of APs in this net
		const int getAPCount() const;

		void       setActive(bool active);
		bool       getActive() const;

		bool operator==(const WirelessNetwork&);

	private:
		WirelessNetworkPrivate * d;
		TDEHardwareDevices* hwdevices;
};

#endif /* TDENETWORKMANAGER_WIRELESS_NETWORK_H */
