/*
 *  Copyright (C) 1999-2002 Bernd Gehrmann
 *                          bernd@mail.berlios.de
 *  Copyright (c) 2003-2004 Christian Loose <christian.loose@kdemail.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */


#ifndef PROTOCOLVIEW_H
#define PROTOCOLVIEW_H

#include <tqtextedit.h>
#include <dcopobject.h>

class TQPoint;
class TQPopupMenu;
class CvsJob_stub;


class ProtocolView : public TQTextEdit, public DCOPObject
{
    K_DCOP
    TQ_OBJECT
//    

public:
    explicit ProtocolView(const TQCString& appId, TQWidget *parent=0, const char *name=0);
    ~ProtocolView();

    bool startJob(bool isUpdateJob = false);

protected:
    virtual TQPopupMenu* createPopupMenu(const TQPoint &pos);

k_dcop:
    void slotReceivedOutput(TQString buffer);
    void slotJobExited(bool normalExit, int exitStatus);

signals:
    void receivedLine(TQString line);
    void jobFinished(bool normalExit, int exitStatus);

private slots:
    void cancelJob();

private:
    void processOutput();
    void appendLine(const TQString &line);

    TQString buf;

    TQColor conflictColor;
    TQColor localChangeColor;
    TQColor remoteChangeColor;

    CvsJob_stub* job;

    bool   m_isUpdateJob;
};

#endif
