#include "dbentries.h"
#include <tqdatastream.h>


void DBItem::set()
{
 TQBuffer b(mydata);
 b.open( IO_WriteOnly );
 TQDataStream s(&b);
 write(&s);
 b.close();
 set_data(mydata.data());
 set_size(mydata.size());
 
}
 void DBItem::get()
 {
	mydata.resize(get_size());
	mydata.duplicate((const char *)get_data(),(unsigned int)get_size());

	TQDataStream *s = new TQDataStream(mydata,IO_ReadOnly);
	read(s);
    delete s;
 }

  

DBItemMainKey::DBItemMainKey()
{
 sstr="";
 //set();
}

DBItemMainKey::DBItemMainKey(TQString searchstring)
{
 sstr=searchstring;
 //set(); 
}
 
void DBItemMainKey::read(TQDataStream *s)
{
*s >> sstr;
}

void DBItemMainKey::write(TQDataStream *s)
{
 *s << sstr;
 }
 
 

  

DBItemMainData::DBItemMainData()
{
 clear();
 //set();
}

void DBItemMainData::clear()
{
 indexnumber=0;
 translations.clear();
 //set();
}
 
void DBItemMainData::read(TQDataStream *s)
{
*s >> indexnumber >> translations;
}

void DBItemMainData::write(TQDataStream *s)
{
 *s << (TQ_UINT32)indexnumber << translations;
}

void DBItemMainData::addTranslation(TQString str, unsigned int ref)
{
//get();
 if(translations[str].find(ref)==translations[str].end())  // If it do not exists
   translations[str].append(ref);  //add a new reference.
  else
  {

  }
//set();
    
}

void DBItemMainData::removeTranslation(TQString str, unsigned int ref)
{
//get();
 translations[str].remove(ref);
 if(translations[str].isEmpty())
   translations.remove(str);
//set();

}

void DBItemMainData::removeRef( unsigned int ref)
{
//get();
TQMapIterator<TQString,TQValueList<unsigned int> > it2;
 for(TQMapIterator<TQString,TQValueList<unsigned int> > it = translations.begin();
     it!= translations.end(); /* it++*/)
	 {  //Dirty hack
	  it2=it;
	  it++;
	  if(it2.data().find(ref)!=it2.data().end())
      removeTranslation(it2.key(),ref);
	 }

//set();
}

TQStringList  DBItemMainData::getTranslations()
{
//get();
TQStringList result;
 for(TQMapIterator<TQString,TQValueList<unsigned int> > it = translations.begin();
     it!= translations.end(); it++)
     result.append(it.key());

return result;

}

TQValueList<unsigned int>  DBItemMainData::getReferences(TQString str)
{
//get();
return translations[str];  //this also add a "str" entry but we do not call set()!
}



DBItemMultiIndex::DBItemMultiIndex()
{
list.clear();
//set();
}
  
void DBItemMultiIndex::addEntry(unsigned int index)
{
// get();
 if(list.find(index)==list.end())
 {
   list.append(index);
   qHeapSort(list);
 //  set();

 }
 
}

void DBItemMultiIndex::removeEntry(unsigned int index)
{
// get();
 list.remove(index);
// set();
}

 
void DBItemMultiIndex::read(TQDataStream *s)
{
*s >> list;
}

void DBItemMultiIndex::write(TQDataStream *s)
{
 *s << list;
 }
