/* This file is part of KCachegrind.
   Copyright (C) 2002, 2003 Josef Weidendorfer <Josef.Weidendorfer@gmx.de>

   KCachegrind is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation, version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

/*
 * KCachegrind top level window
 */

#ifndef TOPLEVEL_H
#define TOPLEVEL_H

#include <tqdatetime.h>

#include <dcopobject.h>
#include <tdemainwindow.h>

#include "traceitemview.h"
#include "tracedata.h"

class MultiView;
class TQLineEdit;
class TQDockWidget;
class TQLabel;
class TQProgressBar;
class TQPopupMenu;

class KURL;
class TDESelectAction;
class TDEToggleAction;
class TDEToolBarPopupAction;

class TraceData;
class TDERecentFilesAction;
class MainWidget;
class PartSelection;
class FunctionSelection;
class DumpSelection;
class StackSelection;
class TraceFunction;

class TopLevel : public TDEMainWindow, public DCOPObject
{
  TQ_OBJECT
  

public:
  TopLevel(const char *name = 0);
  ~TopLevel();

  TraceData* data() { return _data; }
  void setData(TraceData*);

  virtual void saveProperties(TDEConfig*);
  virtual void readProperties(TDEConfig*);

  void createActions();
  void createDocks();

  TraceItem::CostType groupType() { return _groupType; }
  TraceCostType* costType() { return _costType; }
  TraceCostType* costType2() { return _costType2; }
  TracePartList activeParts() { return _activeParts; }
  TracePartList hiddenParts() { return _hiddenParts; }

  // current config
  bool showPercentage() const { return _showPercentage; }
  bool showExpanded() const { return _showExpanded; }
  bool showCycles() const { return _showCycles; }

  /* convenience functions for often used context menu items */
  void addCostMenu(TQPopupMenu*,bool);
  void addGoMenu(TQPopupMenu*);

public slots:
  void newTrace();
  void loadTrace();
  void loadTrace(const KURL&);
  void loadTrace(TQString);
  void addTrace();
  void addTrace(const KURL&);
  void addTrace(TQString);

  // for quick showing the main window...
  void loadDelayed(TQString);

  void reload();
  void exportGraph();
  void newWindow();
  void configure();
  void querySlot();
  void dummySlot();

  // layouts
  void layoutDuplicate();
  void layoutRemove();
  void layoutNext();
  void layoutPrevious();
  void layoutSave();
  void layoutRestore();
  void updateLayoutActions();

  void updateStatusBar();
  void costTypeSelected(const TQString&);
  void costType2Selected(const TQString&);
  void groupTypeSelected(int);
  void splitSlot();
  void splitDirSlot();
  void configureToolbars();
  void configureKeys();
  bool queryExit();
  bool queryClose();
  void togglePartDock();
  void toggleStackDock();
  void toggleFunctionDock();
  void toggleDumpDock();
  void toggleStatusBar();
  void partVisibilityChanged(bool);
  void dumpVisibilityChanged(bool);
  void stackVisibilityChanged(bool);
  void functionVisibilityChanged(bool);
  void togglePercentage();
  void setPercentage(bool);
  void setAbsoluteCost();
  void setRelativeCost();
  void toggleExpanded();
  void toggleCycles();
  void forceTrace();
  void forceTraceReload();
  void forwardAboutToShow();
  void backAboutToShow();
  void upAboutToShow();
  void forwardActivated(int);
  void backActivated(int);
  void upActivated(int);

  bool setCostType(TraceCostType*);
  bool setCostType2(TraceCostType*);
  bool setCostType(TQString);
  bool setCostType2(TQString);
  bool setCostType(int);
  bool setCostType2(int);
  bool setGroupType(TraceItem::CostType);
  bool setGroupType(TQString);
  bool setGroup(TraceCostItem*);
  bool setGroup(TQString);
  bool setFunction(TraceFunction*);
  bool setFunction(TQString);
  void activePartsChangedSlot(const TracePartList& list);
  void partsHideSelectedSlot();
  void partsUnhideAllSlot();

  /* These go back to mainloop first by using a timer.
   * So they can be called from event handlers that
   * aren't allowed to delete list entries.
   */
  void setCostTypeDelayed(TraceCostType*);
  void setCostType2Delayed(TraceCostType*);
  void setGroupTypeDelayed(TraceItem::CostType);
  void setGroupDelayed(TraceCostItem*);
  void setTraceItemDelayed(TraceItem*);
  void partsHideSelectedSlotDelayed();
  void partsUnhideAllSlotDelayed();
  void goBack();
  void goForward();
  void goUp();
  void setDirectionDelayed(TraceItemView::Direction);

  /* SingleShot Slots (without parameters) for the delayed versions */
  void setCostTypeDelayed();
  void setCostType2Delayed();
  void setGroupTypeDelayed();
  void setGroupDelayed();
  void setTraceItemDelayed();
  void loadTraceDelayed();
  void setDirectionDelayed();

  // configuration has changed
  void configChanged();

  //void refresh();
  void slotShowTipOnStart();
  void slotShowTip();

  // progress in status bar, empty message disables progress display
  void showStatus(TQString msg, int progress);
  void showMessage(const TQString&, int msec);

private:
  void init();
  void createLayoutActions();
  void createMiscActions();
  void setupMainWidget(MainWidget*);
  void setupPartSelection(PartSelection*);
  void restoreCurrentState(TQString postfix);
  void saveCurrentState(TQString postfix);
  void saveTraceSettings();
  TQString traceKey();
  void restoreTraceTypes();
  void restoreTraceSettings();

  KStatusBar* _statusbar;
  TQLabel* _statusLabel;
  TDERecentFilesAction* _openRecent;
  bool _twoMainWidgets;
  TQt::Orientation _spOrientation;

  MultiView* _multiView;
  FunctionSelection* _functionSelection;
  DumpSelection* _dumpSelection;
  PartSelection* _partSelection;
  StackSelection* _stackSelection;
  TQLineEdit* queryLineEdit;

  TQDockWindow *_partDock, *_stackDock, *_functionDock, *_dumpDock;
  bool _forcePartDock;

  TDESelectAction *_saCost, *_saCost2, *saGroup;
  TDEToggleAction *_partDockShown, *_stackDockShown;
  TDEToggleAction *_functionDockShown, *_dumpDockShown;
  TDEToggleAction *_taPercentage, *_taExpanded, *_taCycles;
  TDEToggleAction *_taDump, *_taSplit, *_taSplitDir;
  TDEToolBarPopupAction *_paForward, *_paBack, *_paUp;

  TraceFunction* _function;
  const TQObject* _lastSender;

  // trace data shown in this window
  TraceData* _data;
  // subcost types used for visualisation
  TraceCostType* _costType;
  TraceCostType* _costType2;
  // grouping of function list
  TraceItem::CostType _groupType;
  // selected group
  TraceCostItem* _group;
  // selected parts
  TracePartList _activeParts;
  // hidden parts
  TracePartList _hiddenParts;
  // layouts
  int _layoutCurrent, _layoutCount;

  // for delayed slots
  TraceCostType* _costTypeDelayed;
  TraceCostType* _costType2Delayed;
  TraceItem::CostType _groupTypeDelayed;
  TraceCostItem* _groupDelayed;
  TraceItem* _traceItemDelayed;
  TQString _loadTraceDelayed;
  TraceItemView::Direction _directionDelayed;

  // for status progress display
  TQString _progressMsg;
  TQTime _progressStart;
  TQProgressBar* _progressBar;

  // toplevel configuration options
  bool _showPercentage, _showExpanded, _showCycles;
};

#endif
