/***************************************************************************
 *   Copyright (C) 2002 by Roberto Raggi                                   *
 *   roberto@kdevelop.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ast_utils_h
#define __ast_utils_h

#include <tqstring.h>

class AST;
class DeclaratorAST;
class TypeSpecifierAST;
class TQStringList;

namespace KTextEditor{ class EditInterface; }

AST* findNodeAt( AST* unit, int line, int column );
void scopeOfNode( AST* ast, TQStringList& );
TQString typeSpecToString( TypeSpecifierAST* typeSpec );
TQString declaratorToString( DeclaratorAST* declarator, const TQString& scope = TQString(), bool skipPtrOp=false );

#endif // __ast_utils_h
