/***************************************************************************
                                komparesaveoptionswidget.cpp  -  description
                                -------------------
        begin                   : Sun Mar 4 2001
        copyright               : (C) 2001-2003 by Otto Bruggeman
                                  and John Firebaugh
        email                   : otto.bruggeman@home.nl
                                  jfirebaugh@kde.org
****************************************************************************/

/***************************************************************************
**
**   This program is free software; you can redistribute it and/or modify
**   it under the terms of the GNU General Public License as published by
**   the Free Software Foundation; either version 2 of the License, or
**   (at your option) any later version.
**
***************************************************************************/

#include <tqbuttongroup.h>
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqradiobutton.h>
#include <tqspinbox.h>

#include <kdebug.h>
#include <tdefiledialog.h>
#include <kurlrequester.h>

#include "diffsettings.h"
#include "komparesaveoptionswidget.h"

KompareSaveOptionsWidget::KompareSaveOptionsWidget( TQString source, TQString destination,
           DiffSettings * settings, TQWidget * parent )
	: KompareSaveOptionsBase( parent, "save options" )
	, m_source( source )
	, m_destination( destination )
{
	m_settings = settings;

	m_directoryRequester->setMode( static_cast<KFile::Mode>(
	    KFile::ExistingOnly | KFile::Directory | KFile::LocalOnly ) );

	KURL sourceURL;
	KURL destinationURL;
	sourceURL.setPath( source );
	destinationURL.setPath( destination );

	// Find a common root.
	KURL root( sourceURL );
	while( root.isValid() && !root.isParentOf( destinationURL ) ) {
		root = root.upURL();
	}

	// If we found a common root, change to that directory and
	// strip the common part from source and destination.
	if( root.isValid() ) {
		m_directoryRequester->setURL( root.url() );
	}

	connect( m_SmallerChangesCB,   TQ_SIGNAL(toggled(bool)), TQ_SLOT(updateCommandLine()) );
	connect( m_LargeFilesCB,       TQ_SIGNAL(toggled(bool)), TQ_SLOT(updateCommandLine()) );
	connect( m_IgnoreCaseCB,       TQ_SIGNAL(toggled(bool)), TQ_SLOT(updateCommandLine()) );
	connect( m_ExpandTabsCB,       TQ_SIGNAL(toggled(bool)), TQ_SLOT(updateCommandLine()) );
	connect( m_IgnoreEmptyLinesCB, TQ_SIGNAL(toggled(bool)), TQ_SLOT(updateCommandLine()) );
	connect( m_IgnoreWhiteSpaceCB, TQ_SIGNAL(toggled(bool)), TQ_SLOT(updateCommandLine()) );
	connect( m_FunctionNamesCB,    TQ_SIGNAL(toggled(bool)), TQ_SLOT(updateCommandLine()) );
	connect( m_RecursiveCB,        TQ_SIGNAL(toggled(bool)), TQ_SLOT(updateCommandLine()) );
	connect( m_NewFilesCB,         TQ_SIGNAL(toggled(bool)), TQ_SLOT(updateCommandLine()) );
	connect( m_ContextRB,          TQ_SIGNAL(toggled(bool)), TQ_SLOT(updateCommandLine()) );
	connect( m_EdRB,               TQ_SIGNAL(toggled(bool)), TQ_SLOT(updateCommandLine()) );
	connect( m_NormalRB,           TQ_SIGNAL(toggled(bool)), TQ_SLOT(updateCommandLine()) );
	connect( m_RCSRB,              TQ_SIGNAL(toggled(bool)), TQ_SLOT(updateCommandLine()) );
	connect( m_UnifiedRB,          TQ_SIGNAL(toggled(bool)), TQ_SLOT(updateCommandLine()) );
	connect( m_SideBySideRB,       TQ_SIGNAL(toggled(bool)), TQ_SLOT(updateCommandLine()) );
	connect( m_ContextLinesSB,     TQ_SIGNAL(valueChanged(int)), TQ_SLOT(updateCommandLine()) );
	connect( m_directoryRequester, TQ_SIGNAL(textChanged(const TQString&)), TQ_SLOT(updateCommandLine()) );

	loadOptions();
}

KompareSaveOptionsWidget::~KompareSaveOptionsWidget()
{

}

TQString KompareSaveOptionsWidget::directory() const
{
	return KURL( m_directoryRequester->url() ).path();
}

void KompareSaveOptionsWidget::updateCommandLine()
{
	TQString cmdLine = "diff";

	TQString options = "";

	switch( static_cast<Kompare::Format>( m_FormatBG->id( m_FormatBG->selected() ) ) ) {
	case Kompare::Unified :
		cmdLine += " -U " + TQString::number( m_ContextLinesSB->value() );
		break;
	case Kompare::Context :
		cmdLine += " -C " + TQString::number( m_ContextLinesSB->value() );
		break;
	case Kompare::RCS :
		options += "n";
		break;
	case Kompare::Ed :
		options += "e";
		break;
	case Kompare::SideBySide:
		options += "y";
		break;
	case Kompare::Normal :
	case Kompare::UnknownFormat :
	default:
		break;
	}

	if ( m_SmallerChangesCB->isChecked() ) {
		options += "d";
	}

	if ( m_LargeFilesCB->isChecked() ) {
		options += "H";
	}

	if ( m_IgnoreCaseCB->isChecked() ){
		options += "i";
	}

	if ( m_ExpandTabsCB->isChecked() ) {
		options += "t";
	}

	if ( m_IgnoreEmptyLinesCB->isChecked() ) {
		options += "B";
	}

	if ( m_IgnoreWhiteSpaceCB->isChecked() ) {
		options += "b";
	}

	if ( m_FunctionNamesCB->isChecked() ) {
		options += "p";
	}

//	if (  ) {
//		cmdLine += " -w";
//	}

	if ( m_RecursiveCB->isChecked() ) {
		options += "r";
	}

	if( m_NewFilesCB->isChecked() ) {
		options += "N";
	}

//	if( m_AllTextCB->isChecked() ) {
//		options += "a";
//	}

	if( options.length() > 0 ) {
		cmdLine += " -" + options;
	}

	cmdLine += " -- ";
	cmdLine += constructRelativePath( m_directoryRequester->url(), m_source );
	cmdLine += " ";
	cmdLine += constructRelativePath( m_directoryRequester->url(), m_destination );

	m_CommandLineLabel->setText( cmdLine );
}

void KompareSaveOptionsWidget::loadOptions()
{
	m_SmallerChangesCB->setChecked  ( m_settings->m_createSmallerDiff );
	m_LargeFilesCB->setChecked      ( m_settings->m_largeFiles );
	m_IgnoreCaseCB->setChecked      ( m_settings->m_ignoreChangesInCase );
	m_ExpandTabsCB->setChecked      ( m_settings->m_convertTabsToSpaces );
	m_IgnoreEmptyLinesCB->setChecked( m_settings->m_ignoreEmptyLines );
	m_IgnoreWhiteSpaceCB->setChecked( m_settings->m_ignoreWhiteSpace );
	m_FunctionNamesCB->setChecked   ( m_settings->m_showCFunctionChange );
	m_RecursiveCB->setChecked       ( m_settings->m_recursive );
	m_NewFilesCB->setChecked        ( m_settings->m_newFiles );
//	m_AllTextCB->setChecked         ( m_settings->m_allText );

	m_ContextLinesSB->setValue      ( m_settings->m_linesOfContext );

	m_FormatBG->setButton           ( m_settings->m_format );

	updateCommandLine();
}

void KompareSaveOptionsWidget::saveOptions()
{
	m_settings->m_createSmallerDiff   = m_SmallerChangesCB->isChecked();
	m_settings->m_largeFiles          = m_LargeFilesCB->isChecked();
	m_settings->m_ignoreChangesInCase = m_IgnoreCaseCB->isChecked();
	m_settings->m_convertTabsToSpaces = m_ExpandTabsCB->isChecked();
	m_settings->m_ignoreEmptyLines    = m_IgnoreEmptyLinesCB->isChecked();
	m_settings->m_ignoreWhiteSpace    = m_IgnoreWhiteSpaceCB->isChecked();
	m_settings->m_showCFunctionChange = m_FunctionNamesCB->isChecked();
	m_settings->m_recursive           = m_RecursiveCB->isChecked();
	m_settings->m_newFiles            = m_NewFilesCB->isChecked();
//	m_settings->m_allText             = m_AllTextCB->isChecked();

	m_settings->m_linesOfContext      = m_ContextLinesSB->value();

	m_settings->m_format = static_cast<Kompare::Format>( m_FormatBG->id( m_FormatBG->selected() ) );

}

#include "komparesaveoptionswidget.moc"
