/* This file is part of KCachegrind.
   Copyright (C) 2002, 2003 Josef Weidendorfer <Josef.Weidendorfer@gmx.de>

   KCachegrind is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation, version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

/*
 * For function selection, to be put into a TQDockWindow
 */

#ifndef FUNCTIONSELECTION_H
#define FUNCTIONSELECTION_H

#include "functionselectionbase.h"
#include "traceitemview.h"
#include "tracedata.h"
#include "listutils.h"

class TQPopupMenu;

class TraceFunction;
class TraceData;
class StackBrowser;
class NestedAreaItem;

class FunctionSelection : public FunctionSelectionBase, public TraceItemView
{
  TQ_OBJECT
  

public:
  FunctionSelection( TopLevel*, TQWidget* parent = 0, const char* name = 0);
  ~FunctionSelection();

  TraceCostItem* group(TQString);
  void setGroup(TraceCostItem*);
  void query(TQString);
  bool setTopFunction();

  TQWidget* widget() { return this; }

  void addGroupMenu(TQPopupMenu*);

public slots:
  void searchReturnPressed();
  void searchChanged(const TQString&);
  void queryDelayed();
  void groupDoubleClicked( TQListViewItem* );
  void functionActivated( TQListViewItem* );
  void groupSelected( TQListViewItem* );
  void functionSelected( TQListViewItem* );
  void functionContext(TQListViewItem*, const TQPoint &, int);
  void groupContext(TQListViewItem*, const TQPoint &, int);

private:
  TraceItem* canShow(TraceItem* i);
  void doUpdate(int);
  void selectFunction();
  void refresh();
  void setCostColumnWidths();
  void updateGroupSizes(bool hideEmpty);

  TraceCostItem* _group;

  TQString _searchString, _searchDelayed;
  TQTimer _searchTimer;
  TQMap<TraceCostItem*,int> _groupSize;

  HighestCostList _hc;
  // when setting a
  bool _inSetGroup, _inSetFunction;
};

#endif
