/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2004-2006                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

/*  This code generated by:
 *      Author : thomas
 *      Date   : Wed Jun 18 2003
 */

#ifndef CODEDOCUMENT_H
#define CODEDOCUMENT_H

#include <tqobject.h>
#include <tqmap.h>
#include <tqstring.h>

#include "codegenerationpolicy.h"
#include "codegenobjectwithtextblocks.h"
#include "hierarchicalcodeblock.h"

class TQWidget;
class CodeAccessorMethod;
class CodeBlockWithComments;
class CodeComment;
class CodeOperation;
class TextBlock;
class UMLPackage;

//#include "codedocumentdialog.h"

/**
  * class CodeDocument
  * A document containing the code for one file.
  */

// "friend" status is needed for HBlock so it may call addChildTagToMap which
// is protected.
class CodeDocument : public TQObject, public CodeGenObjectWithTextBlocks
{
    friend class HierarchicalCodeBlock;
    TQ_OBJECT
  
public:

    // Constructors/Destructors
    //


    /**
     * Empty Constructor
     */
    /**
     * Basic constructor for class.
     */
    CodeDocument ( );

    /**
     * Empty Destructor
     */
    virtual ~CodeDocument ( );

    // Public attributes
    //

    // Public attribute accessor methods
    //

    /**
     * Set the value of m_fileExtension
     * @param new_var the new value of m_fileExtension
     */
    void setFileExtension ( const TQString &new_var );

    /**
     * Get the value of m_fileExtension
     * @return the value of m_fileExtension
     */
    TQString getFileExtension ( ) const;

    /**
     * Set the complete value (name plus any extension) of m_filename
     * @param new_var the new value of m_filename
     */
    void setFileName ( const TQString &new_var );

    /**
     * Get the value of m_filename. This name is the "complete" filename,
     * meaning that it contains both the file name plus any extension (e.g. "file.cpp")
     * @return the value of m_filename
     */
    TQString getFileName ( ) const;

    /**
     * Set the value of m_package
     * @param new_var the new value of m_package
     */
    void setPackage ( UMLPackage *new_var );

    /**
     * Get the value of the package of this codedocument.
     * @return the value of m_pathName
     */
    TQString getPackage ( ) const;

    /**
     * Get the value of the path to this codedocument.
     * @return the value of m_pathName
     */
    virtual TQString getPath ( );

    /**
     * Set the value of m_ID
     * @param new_id the new value of m_ID
     */
    void setID ( const TQString &new_id);

    /**
     * Get the value of m_ID
     * @return the value of m_ID
     */
    TQString getID ( ) const;

    /**
     * Set the value of m_writeOutCode
     * Whether or not to write out this code document and any codeblocks, etc that it
     * owns.
     * @param new_var the new value of m_writeOutCode
     */
    void setWriteOutCode ( bool new_var );

    /**
     * Get the value of m_writeOutCode
     * Whether or not to write out this code document and any codeblocks, etc that it
     * owns.
     * @return the value of m_writeOutCode
     */
    bool getWriteOutCode ( );

    /**
     * Set a Header comment object
     */
    void setHeader ( CodeComment * comment );

    /**
     * Get the Header comment object
     */
    CodeComment * getHeader ( );

    /**
     * Insert a new text block after the existing text block. Returns
     * false if it cannot insert the textblock.
     */
    bool insertTextBlock (TextBlock * newBlock, TextBlock * existingBlock, bool after = true);

    /**
     * Lookup a certain textblock by its tag value, returns NULL if it cant
     * find the TextBlock with such a tag. If descendIntoChildren is true, then
         * any child hierarchical textblocks will also be searched for a match.
         */
    TextBlock * findTextBlockByTag( const TQString &tag , bool descendIntoChildren = false);

    /**
     * create the string representation of this object.
     * @return  TQString
     */
    virtual TQString toString ( );

    /**
     * Save the XMI representation of this object
     */
    virtual void saveToXMI ( TQDomDocument & doc, TQDomElement & root );

    /**
         * load params from the appropriate XMI element node.
     */
    virtual void loadFromXMI ( TQDomElement & root );

    /**
    * create a new CodeBlock object belonging to this CodeDocument.
    * @return      CodeBlock
    */
    virtual CodeBlock * newCodeBlock ( );

    /**
     * create a new HierarchicalCodeBlock object belonging to this CodeDocument.
     * @return  HierarchicalCodeBlock
     */
    virtual HierarchicalCodeBlock * newHierarchicalCodeBlock ( );

    /**
     * create a new CodeBlockWithComments object belonging to this CodeDocument.
     * @return  CodeBlockWithComments
     */
    virtual CodeBlockWithComments * newCodeBlockWithComments ( );

    // return a unique, and currently unallocated, text block tag for this document
    virtual TQString getUniqueTag( const TQString& prefix = TQString("") );

    /** a little utility method to make life easier for the code document programmer
     */
    TQString cleanName ( const TQString &name );

    // Cause this code document to synchronize to current generator policy
    virtual void synchronize();


protected:

    /** set attributes of the node that represents this class
    * in the XMI document.
    */
    virtual void setAttributesOnNode ( TQDomDocument & doc, TQDomElement & blockElement);

    /** set the class attributes of this object from
     * the passed element node.
     */
    virtual void setAttributesFromNode ( TQDomElement & element);

    // these next 2 are needed by child hierarchical code blocks so
    // that when they call getUniqueTag, we really get a unique tag
    // Also, it allows 'findTextBlockByTag' To find any tagged text block
    // anywhere in the document, whether directly owned by the document OR
    // by some child hierarchical textblock
    void addChildTagToMap ( const TQString &tag, TextBlock * tb);
    void removeChildTagFromMap ( const TQString &tag );

    // update the header text of this codedocument
    void updateHeader ();

    // reset/clear our inventory of textblocks in this document
    void resetTextBlocks();

    // update the content of this code document
    // this is where you should lay out your code document structure of textblocks
    // in the inheriting class, should it have any text in it.
    virtual void updateContent();

    // have to implement this for CodeObjectWithTextBlocks
    // doenst actually do anythying fo ra vannilla code document
    virtual TextBlock * findCodeClassFieldTextBlockByTag( const TQString &tag );

private:

    int lastTagIndex;
    TQString m_filename;
    TQString m_fileExtension;
    TQString m_ID;
    TQString m_pathName;
    UMLPackage *m_package;

    bool m_writeOutCode; // Whether or not to write out this code document
    // and any codeblocks, etc that it owns.

    CodeComment * m_header;


    void initDoc ( ) ;

    // TextBlockList m_textblockVector;
    // TQMap<TQString, TextBlock *> m_textBlockTagMap;

    // for recording all of the textblocks held by child hierarchical codeblocks
    TQMap<TQString, TextBlock *> m_childTextBlockTagMap;

};

#endif // CODEDOCUMENT_H
