#include <kiconloader.h>

struct WeatherSingleIconData {
	TQString name;
	TQString path;
	bool inTheme;
	uint size;
};

class WeatherIconPrivate {
	friend class WeatherIcon;

	public:
		WeatherIconPrivate();
		~WeatherIconPrivate();

		static WeatherIconPrivate* instance();

		void useIconTheme(bool use);
		bool usingIconTheme();

		TQString iconPath(TQString icon, uint size, bool inTheme);
		TQString iconPath(TQString icon, uint size);

	private:
		static WeatherIconPrivate* s_instance;
		TDEIconLoader* iconLoader;
		bool m_useIconTheme;

		struct WeatherSingleIconData findIcon(TQStringList fallback, uint size);
};

class WeatherIcon {
	public:
		enum SimpleCondition { Sunny, Fog, Mist, Overcast, Hail, LightRain, Sleet };
		enum RangedCondition { Cloudy, Showers, Snow, Thunderstorm };

		WeatherIcon( int condition /* SimpleCondition */, bool night );
		WeatherIcon( int condition /* RangedCondition */, bool night, unsigned int strength );
		WeatherIcon(); /* Unknown conditions */
		~WeatherIcon();

		static struct WeatherSingleIconData unknown(uint size); // for convenience

		struct WeatherSingleIconData iconData(uint size);
		TQString name(uint size);
		TQString path(uint size);

	private:
		TQStringList fallback;
};
