/*
 *  Copyright (C) 2001 Matthias Hoelzer-Kluepfel <mhk@caldera.de>   
 */


#ifndef __KDEVPART_TOOLS_H__
#define __KDEVPART_TOOLS_H__


#include <tqguardedptr.h>
#include <kdevplugin.h>
#include <kdevgenericfactory.h>


class TQPopupMenu;
class KDialogBase;
class Context;
class ConfigWidgetProxy;

class ToolsWidget;


class ToolsPart : public KDevPlugin
  {
    TQ_OBJECT
  

public:

    ToolsPart( TQObject *parent, const char *name, const TQStringList & );
    ~ToolsPart();


private slots:
	void insertConfigWidget( const KDialogBase * dlg, TQWidget * page, unsigned int pagenumber );
    void updateMenu();

	void slotToolActivated();

    void contextMenu(TQPopupMenu *popup, const Context *context);
    void updateToolsMenu();
    void toolsMenuActivated();
    void fileContextActivated(int id);
    void dirContextActivated(int id);
      
private:
    void startCommand(TQString cmdline, bool captured, TQString fileName);

    TQPopupMenu *m_contextPopup;
    TQString m_contextFileName;
	ConfigWidgetProxy * m_configProxy;
  };

typedef KDevGenericFactory<ToolsPart> ToolsFactory;

#endif
