/***************************************************************************
 *   Copyright (C) 2003 by Hendrik Kueck                                   *
 *   kueck@cs.ubc.ca                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef CUSTOMMAKECONFIGWIDGET_H
#define CUSTOMMAKECONFIGWIDGET_H

#include "domutil.h"

#include <custommakeconfigwidgetbase.h>

class CustomProjectPart;
class EnvironmentVariablesWidget;

/**
@author KDevelop Authors
*/
class CustomMakeConfigWidget : public CustomMakeConfigWidgetBase
{
    TQ_OBJECT
  

public:
    CustomMakeConfigWidget(CustomProjectPart* part, const TQString& configGroup, TQWidget* parent);

    ~CustomMakeConfigWidget();

public slots:
    void accept();

protected:
    CustomProjectPart* m_part;
    TQString m_configGroup;
    TQDomDocument& m_dom;

    TQStringList m_allEnvironments;
    TQString m_currentEnvironment;

    EnvironmentVariablesWidget* m_envWidget;

    virtual void envNameChanged(const TQString& envName);
    virtual void envChanged(const TQString& envName);
    virtual void envAdded();
    virtual void envRemoved();
    virtual void envCopied();

};

#endif
