/***************************************************************************
 *   Copyright (C) 2003 Cedric Pasteur                                     *
 *   <cedric.pasteur@free.fr>                                              *
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "ppixmapedit.h"

#include <tqlayout.h>
#include <tqpainter.h>
#include <tqlabel.h>
#include <tqcursor.h>

#ifndef PURE_QT
#include <tdelocale.h>
#else
#include "compat_tools.h"
#endif

#ifndef PURE_QT
#include <tdefiledialog.h>
#else
#include <tqfiledialog.h>
#endif
#include <tqpushbutton.h>

namespace PropertyLib{

PPixmapEdit::PPixmapEdit(MultiProperty* property, TQWidget* parent, const char* name)
    :PropertyWidget(property, parent, name)
{
    TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
    m_edit = new TQLabel(this);
    m_edit->setAlignment(TQt::AlignTop);
    m_edit->resize(width(), height()-1);
    m_edit->setBackgroundMode(TQt::PaletteBase);
    m_edit->installEventFilter(this);
    
    m_button = new TQPushButton(i18n("..."), this);
    m_button->resize(height(), height()-8);
    m_button->move(width() - m_button->width() -1, 0);
    m_button->setSizePolicy(TQSizePolicy::Maximum, TQSizePolicy::Fixed);
    l->addWidget(m_edit);
    l->addWidget(m_button);
    m_popup = new TQLabel(0, 0, TQt::WStyle_NoBorder|TQt::WX11BypassWM|WStyle_StaysOnTop);
    m_popup->hide();
    

    connect(m_button, TQ_SIGNAL(clicked()), this, TQ_SLOT(updateProperty()));
}

TQVariant PPixmapEdit::value() const
{
    return TQVariant(*(m_edit->pixmap()));
}

void PPixmapEdit::drawViewer(TQPainter* p, const TQColorGroup& cg, const TQRect& r, const TQVariant& value)
{
    p->setPen(TQt::NoPen);
    p->setBrush(cg.background());
    p->drawRect(r);
    p->drawPixmap(r.topLeft().x(), r.topLeft().y(), value.toPixmap());    
}

void PPixmapEdit::setValue(const TQVariant& value, bool emitChange)
{
    m_edit->setPixmap(value.toPixmap());
    if (emitChange)
        emit propertyChanged(m_property, value);
}

void PPixmapEdit::updateProperty()
{
#ifndef PURE_QT
    KURL url = KFileDialog::getImageOpenURL(TQString(), this);
    if (!url.isEmpty())
    {
        m_edit->setPixmap(TQPixmap(url.path()));
        emit propertyChanged(m_property, value());
    }
#else
    TQString url = TQFileDialog::getOpenFileName();
    if (!url.isEmpty())
    {
        m_edit->setPixmap(TQPixmap(url));
        emit propertyChanged(m_property, value());
    }
#endif
}

void PPixmapEdit::resizeEvent(TQResizeEvent *ev)
{
    m_edit->resize(ev->size().width(), ev->size().height()-1);
    m_button->move(ev->size().width() - m_button->width(), 0);
    m_edit->setMaximumHeight(m_button->height());
}

bool PPixmapEdit::eventFilter(TQObject *o, TQEvent *ev)
{
    if(o == m_edit)
    {
        if(ev->type() == TQEvent::MouseButtonPress)
        {
            if(m_edit->pixmap()->size().height() < height()-2
                    && m_edit->pixmap()->size().width() < width()-20)
                    return false;
            m_popup->setPixmap(*(m_edit->pixmap()));
            m_popup->resize(m_edit->pixmap()->size());
            m_popup->move(TQCursor::pos());
            m_popup->show();
        }
        if(ev->type() == TQEvent::MouseButtonRelease)
        {
            if(m_popup->isVisible())
                    m_popup->hide();
        }
        if(ev->type() == TQEvent::KeyPress)
        {
            TQKeyEvent* e = static_cast<TQKeyEvent*>(ev);
            if((e->key() == Key_Enter) || (e->key()== Key_Space) || (e->key() == Key_Return))
            {
                    m_button->animateClick();
                    return true;
            }
        }
    }
    return PropertyWidget::eventFilter(o, ev);
}

}

#ifndef PURE_QT
#include "ppixmapedit.moc"
#endif
