/***************************************************************************
 *   Copyright (C) 2005 by Jens Herden                                     *
 *   jens@kdewebdev.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef TOOLBARGUIBUILDER_H
#define TOOLBARGUIBUILDER_H

#include <kxmlguibuilder.h>
#include <kdebug.h>
#include <tdetoolbar.h>


/**
* Reimplemented the KXMLGUIBuilder in order use our toolbar in the 
* toolview
* @author Jens Herden
*/
class ToolbarGUIBuilder : public KXMLGUIBuilder, public TDEToolBar
{
public:
  ToolbarGUIBuilder(TQWidget *parent, TQWidget *widget);

  virtual ~ToolbarGUIBuilder();
  
  /**
  * Called when a new XML gui client is added to the gui factory. 
  */
  virtual TQWidget *createContainer(TQWidget *parent, int index, const TQDomElement &element, int &id);
  
  /**
   * Called when a XML gui client is removed the gui factory. 
   * Reimplemented from KXMLGUIBuilder in order to remove our custom toolbar.
   */
  virtual void removeContainer(TQWidget *container, TQWidget *parent, TQDomElement &element, int id);
  
private:
  TQWidget * m_parent;
};



#endif
