/***************************************************************************
 *   Copyright (C) 2003 by Mario Scalas                                    *
 *   mario.scalas@libero.it                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klineedit.h>
#include <tqcheckbox.h>

#include "tagdialog.h"

///////////////////////////////////////////////////////////////////////////////
// class TagDialog
///////////////////////////////////////////////////////////////////////////////

TagDialog::TagDialog( const TQString &caption, TQWidget *parent, const char *name )
    : TagDialogBase( parent, name ? name : "tagdialog", true )
{
    if (!caption.isEmpty())
    {
        setCaption( caption );
    }
}

///////////////////////////////////////////////////////////////////////////////

TagDialog::~TagDialog()
{
}

///////////////////////////////////////////////////////////////////////////////

void TagDialog::accept()
{
    if (tagBranchEdit->text().isEmpty())
        return;

    TagDialogBase::accept();
}

///////////////////////////////////////////////////////////////////////////////

TQString TagDialog::tagName() const
{
    return tagBranchEdit->text();
}

///////////////////////////////////////////////////////////////////////////////

TQString TagDialog::branchName() const
{
    return tagName();
}

///////////////////////////////////////////////////////////////////////////////

bool TagDialog::isBranch() const
{
    return tagAsBranchCheck->isChecked();
}

///////////////////////////////////////////////////////////////////////////////

bool TagDialog::force() const
{
    return forceCheck->isChecked();
}

#include "tagdialog.moc"
