/***************************************************************************
                          arealistview.cpp  -  description
                             -------------------
    begin                : Weg Feb 26 2003
    copyright            : (C) 2003 by Jan Schfer
    email                : janschaefer@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// QT
#include <tdelistview.h>
#include <tqpushbutton.h>
#include <tqhbox.h>
#include <tqwhatsthis.h>
#include <tqtooltip.h>

// KDE
#include <kiconloader.h>
#include <tdelocale.h>

// local
#include "kimearea.h"
#include "arealistview.h"


AreaListView::AreaListView(TQWidget *parent, const char *name)
  : TQVBox(parent, name)
{
  listView = new TDEListView(this);
  listView->addColumn(i18n("Areas"));
  listView->addColumn(i18n("Preview"));

  listView->setMultiSelection(true);
  listView->setSelectionMode( TQListView::Extended );
  listView->setSorting(-1); // The user can't sort by clicking on the header
  listView->setFullWidth(true);


  TQWhatsThis::add( listView, i18n("<h3>Area List</h3>The area list shows you all areas of the map.<br>"
                                  "The left column shows the link associated with the area; the right "
                                  "column shows the part of the image that is covered by the area.<br>"
                                  "The maximum size of the preview images can be configured."));
  TQToolTip::add( listView, i18n("A list of all areas"));

  TQHBox *hbox= new TQHBox(this);
  upBtn= new TQPushButton("",hbox);
  upBtn->setIconSet(SmallIconSet("go-up"));

  downBtn= new TQPushButton("",hbox);
  downBtn->setIconSet(SmallIconSet("go-down"));

}


AreaListView::~AreaListView()
{
}

#include "arealistview.moc"
