/***************************************************************************
                                              cvsservice.h  -  description
                                             ------------------------------
    begin                : Sun May 16 17:50:25 2004
    copyright          : (C) 2004, 2005 by Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2
 *
 ***************************************************************************/

#ifndef CVSSERVICE_H
#define CVSSERVICE_H

//qt includes
#include <tqobject.h>

//kde includes
#include <dcopref.h>

//own includes
#include "cvsservicedcopif.h"

class TQTimer;
class TDEPopupMenu;
class TDEActionCollection;
class CvsJob_stub;
class CvsService_stub;
class Repository_stub;

class CVSCommitDlgS;
class CVSUpdateToDlgS;

/** @short This class manages the CVS repositories from withing Quanta with the help of "cvsservice"
 *
 */
class CVSService : public TQObject, public CVSServiceDCOPIf
{
  TQ_OBJECT
  

public:

  /**
   *  since this class is a singleton you must use this function to access it
   *  @return the class pointer
   */
  static CVSService* ref(TDEActionCollection *ac = 0L)
  {
    static CVSService *m_ref;
    if (!m_ref) m_ref = new CVSService(ac);
    return m_ref;
  }

  ~CVSService();

  void setAppId(const TQCString& id);
  /** Returns true if the cvsservice was found */
  bool exists() {return !m_appId.isEmpty();}
  void setRepository(const TQString &repository);
  void setCurrentFile(const TQString &file) {m_defaultFile = file;}
  TDEPopupMenu *menu() {return m_menu;}

public slots:
  void slotUpdate();
  void slotUpdate(const TQStringList &files);
  void slotUpdateToTag();
  void slotUpdateToTag(const TQStringList &files);
  void slotUpdateToHead();
  void slotUpdateToHead(const TQStringList &files);
  void slotCommit();
  void slotCommit(const TQStringList &files);
  void slotRevert();
  void slotRevert(const TQStringList &files);
  void slotAdd();
  void slotAdd(const TQStringList &files);
  void slotRemove();
  void slotRemove(const TQStringList &files);
  void slotBrowseLog();
  void slotAddToCVSIgnore();
  void slotRemoveFromCVSIgnore();

  virtual void slotJobExited(bool normalExit, int exitStatus);
  virtual void slotReceivedStdout(TQString output);
  virtual void slotReceivedStderr(TQString output);

signals:
  void clearMessages();
  void showMessage(const TQString &msg, bool append);
  void commandExecuted(const TQString& command, const TQStringList& files);

private slots:  
  void slotTimeout();
  
private:
  CVSService(TDEActionCollection *ac);
  void notInRepository();
  void startService();

  TQCString m_appId;
  TDEPopupMenu *m_menu;
  Repository_stub *m_repository;
  CvsJob_stub *m_cvsJob;
  CvsService_stub *m_cvsService;
  TQString m_defaultFile;
  TQString m_repositoryPath;
  TQString m_cvsCommand;
  TQStringList m_files;
  CVSCommitDlgS *m_commitDlg;
  CVSUpdateToDlgS *m_updateToDlg;
  DCOPRef m_job;
  TQTimer *m_timer;
};

#endif
