/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef SIZEHANDLE_H
#define SIZEHANDLE_H

#include <tqwidget.h>
#include <tqintdict.h>
#include <tqptrdict.h>

class TQMouseEvent;
class FormWindow;
class WidgetSelection;
class TQPaintEvent;

class SizeHandle : public TQWidget
{
    TQ_OBJECT
  

public:
    enum Direction { LeftTop, Top, RightTop, Right, RightBottom, Bottom, LeftBottom, Left };

    SizeHandle( FormWindow *parent, Direction d, WidgetSelection *s );
    void setWidget( TQWidget *w );
    void setActive( bool a );
    void updateCursor();

    void setEnabled( bool ) {}

protected:
    void paintEvent( TQPaintEvent *e );
    void mousePressEvent( TQMouseEvent *e );
    void mouseMoveEvent( TQMouseEvent *e );
    void mouseReleaseEvent( TQMouseEvent *e );

private:
    void trySetGeometry( TQWidget *w, int x, int y, int width, int height );
    void tryResize( TQWidget *w, int width, int height );

private:
    TQWidget *widget;
    Direction dir;
    TQPoint oldPressPos;
    FormWindow *formWindow;
    WidgetSelection *sel;
    TQRect geom, origGeom;
    bool active;

};

class WidgetSelection
{
public:
    WidgetSelection( FormWindow *parent, TQPtrDict<WidgetSelection> *selDict );

    void setWidget( TQWidget *w, bool updateDict = true );
    bool isUsed() const;

    void updateGeometry();
    void hide();
    void show();
    void update();
    
    TQWidget *widget() const;

protected:
    TQIntDict<SizeHandle> handles;
    TQWidget *wid;
    FormWindow *formWindow;
    TQPtrDict<WidgetSelection> *selectionDict;

};

#endif
