#################################################
#
#  (C) 2016 Slávek Banko
#  slavek.banko (AT) axis.cz
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_compiler_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


set( ENV{PKG_CONFIG_PATH} "${PKG_CONFIG_PATH}:$ENV{PKG_CONFIG_PATH}:${LIB_INSTALL_DIR}/pkgconfig" )


##### check system configuration ################

check_symbol_exists( strdup "string.h" HAVE_STRDUP_DECL )
check_type_size( ushort USHORT )
check_type_size( boolean BOOLEAN )

check_type_size( "int" SIZEOF_INT )
check_type_size( "long" SIZEOF_LONG )
check_type_size( "short" SIZEOF_SHORT )
check_type_size( "unsigned char" SIZEOF_UNSIGNED_CHAR )
check_type_size( "unsigned int" SIZEOF_UNSIGNED_INT )
check_type_size( "unsigned long" SIZEOF_UNSIGNED_LONG )
check_type_size( "unsigned short" SIZEOF_UNSIGNED_SHORT )

pkg_search_module( LIBXML libxml-2.0>=2.6.0 )
if( NOT LIBXML_FOUND )
  tde_message_fatal( "libxml at least 2.6.0 is required, but not found on your system" )
endif( NOT LIBXML_FOUND )

pkg_search_module( LIBXSLT libexslt>=0.8.0 )
if( NOT LIBXSLT_FOUND )
  pkg_search_module( LIBXSLT libxslt>=1.0.19 )
  if( NOT LIBXSLT_FOUND )
    tde_message_fatal( "libxslt at least 1.0.19 is required, but not found on your system" )
  endif( )
endif( NOT LIBXSLT_FOUND )

pkg_search_module( TAGLIB taglib )
if( TAGLIB_FOUND )
  set( HAVE_TAGLIB 1 )
endif( TAGLIB_FOUND )

pkg_search_module( YAZ yaz )
if( YAZ_FOUND )
  set( HAVE_YAZ 1 )
endif( YAZ_FOUND )

if( WITH_LIBKCDDB )
  message( "-- checking for 'libkcddb'" )

  find_path(
    LIBKCDDB_INCLUDE_DIR
      cddb.h
    PATHS
      ${TDE_INCLUDE_DIR}/tde/libkcddb
      ${TDE_INCLUDE_DIR}/libkcddb
    NO_DEFAULT_PATH
  )

  find_library(
    LIBKCDDB_LIBRARY
      kcddb
    PATHS
      ${TDE_LIB_DIR}
      ${TQT_LIBRARY_DIRS}
  )
  if( LIBKCDDB_LIBRARY )
    get_filename_component( LIBKCDDB_LIBRARY_DIR ${LIBKCDDB_LIBRARY} PATH CACHE )
  endif( )

  if( NOT LIBKCDDB_INCLUDE_DIR OR NOT LIBKCDDB_LIBRARY_DIR )
    tde_message_fatal( "libkcddb is required, but was not found on your system" )
  else( )
    set( HAVE_KCDDB 1 )
  endif( )
endif( WITH_LIBKCDDB )

if( WITH_LIBKCAL )
  message( "-- checking for 'libkcal'" )

  find_path(
    LIBKCAL_INCLUDE_DIR
      kcalversion.h
    PATHS
      ${TDE_INCLUDE_DIR}/libkcal
      ${TDE_INCLUDE_DIR}
      ${TQT_INCLUDE_DIRS}
  )

  find_library(
    LIBKCAL_LIBRARY
      kcal
    PATHS
      ${TDE_LIB_DIR}
      ${TQT_LIBRARY_DIRS}
  )
  if( LIBKCAL_LIBRARY )
    get_filename_component( LIBKCAL_LIBRARY_DIR ${LIBKCAL_LIBRARY} PATH CACHE )
  endif( )

  if( NOT LIBKCAL_INCLUDE_DIR OR NOT LIBKCAL_LIBRARY_DIR )
    tde_message_fatal( "libkcal is required, but was not found on your system" )
  else( )
    set( HAVE_KCAL 1 )
  endif( )
endif( WITH_LIBKCAL )

if( WITH_LIBBTPARSE )
  check_library_exists( btparse bt_initialize "" HAVE_LIBBTPARSE )
  if( NOT HAVE_LIBBTPARSE )
    tde_message_fatal( "libbtparse is required, but was not found on your system" )
  endif( NOT HAVE_LIBBTPARSE )
  set( BTPARSE_LIBRARIES btparse )
else( )
  set( BTPARSE_LIBRARIES btparse-static )
endif( WITH_LIBBTPARSE )

if( WITH_SAX )
  set( SAX_SUPPORT 1 CACHE INTERNAL "" )
endif( WITH_SAX )


if( BUILD_AMAZON_SUPPORT )
  set( AMAZON_SUPPORT 1 CACHE INTERNAL "" )
endif( BUILD_AMAZON_SUPPORT )

if( BUILD_IMDB_SUPPORT )
  set( IMDB_SUPPORT 1 CACHE INTERNAL "" )
endif( BUILD_IMDB_SUPPORT )

if( BUILD_CDTEXT_SUPPORT )
  set( USE_CDTEXT 1 CACHE INTERNAL "" )
endif( BUILD_CDTEXT_SUPPORT )

if( BUILD_OOO_SUPPORT )
  # FIXME - add configure checks for LibreOffice/OpenOffice.org
  #set( WITH_OOO 1 CACHE INTERNAL "" )
  tde_message_fatal( "CMake build with LibreOffice/OpenOffice.org support is not yet complete" )
endif( BUILD_OOO_SUPPORT )

if( BUILD_EXEMPI_SUPPORT )
  pkg_search_module( EXEMPI exempi-2.0>=1.99.0 )
  if( NOT EXEMPI_FOUND )
    tde_message_fatal( "exempi at least 1.99.0 is required, but not found on your system" )
  else( )
    set( HAVE_EXEMPI 1 CACHE INTERNAL "" )
  endif( )
endif( BUILD_EXEMPI_SUPPORT )

if( BUILD_POPPLER_SUPPORT )
  pkg_search_module( POPPLER poppler-tqt>=0.5 )
  if( NOT POPPLER_FOUND )
    tde_message_fatal( "poppler-tqt at least 0.5 is required, but not found on your system" )
  else( )
    set( HAVE_POPPLER 1 CACHE INTERNAL "" )
  endif( )
endif( BUILD_POPPLER_SUPPORT )

if( BUILD_WEBCAM_SUPPORT )
  check_include_file( "libv4l1-videodev.h" HAVE_LIBV4L1_VIDEODEV_H )
  if( HAVE_LIBV4L1_VIDEODEV_H )
    set( ENABLE_WEBCAM 1 CACHE INTERNAL "" )
    set( VIDEODEV_HEADER "libv4l1-videodev.h" CACHE INTERNAL "" )
  else( )
    check_include_file( "linux/videodev.h" HAVE_VIDEODEV_H )
    if( HAVE_VIDEODEV_H )
      set( ENABLE_WEBCAM 1 CACHE INTERNAL "" )
      set( VIDEODEV_HEADER "linux/videodev.h" CACHE INTERNAL "" )
    else( )
      tde_message_fatal( "libv4l1-videodev.h or linux/videodev.h is required, but not found on your system" )
    endif( )
  endif( )
  set( WEBCAM_LIBRARIES barcode-static )
endif( BUILD_WEBCAM_SUPPORT )
