/***************************************************************************
    copyright            : (C) 2004-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#include "dcopinterface.h"
#include "../latin1literal.h"
#include "../controller.h"
#include "../tellico_kernel.h"
#include "../document.h"
#include "../collection.h"
#include "../translators/bibtexhandler.h"

using Tellico::ApplicationInterface;
using Tellico::CollectionInterface;

Tellico::Import::Action ApplicationInterface::actionType(const TQString& actionName) {
  TQString name = actionName.lower();
  if(name == Latin1Literal("append")) {
    return Import::Append;
  } else if(name == Latin1Literal("merge")) {
    return Import::Merge;
  }
  return Import::Replace;
}

TQValueList<long> ApplicationInterface::selectedEntries() const {
  TQValueList<long> ids;
  Data::EntryVec entries = Controller::self()->selectedEntries();
  for(Data::EntryVecIt entry = entries.begin(); entry != entries.end(); ++entry) {
    ids << entry->id();
  }
  return ids;
}

TQValueList<long> ApplicationInterface::filteredEntries() const {
  TQValueList<long> ids;
  Data::EntryVec entries = Controller::self()->visibleEntries();
  for(Data::EntryVecIt entry = entries.begin(); entry != entries.end(); ++entry) {
    ids << entry->id();
  }
  return ids;
}

long CollectionInterface::addEntry() {
  Data::CollPtr coll = Data::Document::self()->collection();
  if(!coll) {
    return -1;
  }
  Data::EntryPtr entry = new Data::Entry(coll);
  Kernel::self()->addEntries(entry, false);
  return entry->id();
}

bool CollectionInterface::removeEntry(long id_) {
  Data::CollPtr coll = Data::Document::self()->collection();
  if(!coll) {
    return false;
  }
  Data::EntryPtr entry = coll->entryById(id_);
  if(!entry) {
    return false;
  }
  Kernel::self()->removeEntries(entry);
  return coll->entryById(id_) == 0;
}

TQStringList CollectionInterface::values(const TQString& fieldName_) const {
  TQStringList results;
  Data::CollPtr coll = Data::Document::self()->collection();
  if(!coll) {
    return results;
  }
  Data::FieldPtr field = coll->fieldByName(fieldName_);
  if(!field) {
    field = coll->fieldByTitle(fieldName_);
  }
  if(!field) {
    return results;
  }
  Data::EntryVec entries = Controller::self()->selectedEntries();
  for(Data::EntryVecIt entry = entries.begin(); entry != entries.end(); ++entry) {
    results += entry->fields(field, false);
  }
  return results;
}

TQStringList CollectionInterface::values(long id_, const TQString& fieldName_) const {
  TQStringList results;
  Data::CollPtr coll = Data::Document::self()->collection();
  if(!coll) {
    return results;
  }
  Data::FieldPtr field = coll->fieldByName(fieldName_);
  if(!field) {
    field = coll->fieldByTitle(fieldName_);
  }
  if(!field) {
    return results;
  }
  Data::EntryPtr entry = coll->entryById(id_);
  if(entry) {
    results += entry->fields(field, false);
  }
  return results;
}

TQStringList CollectionInterface::bibtexKeys() const {
  Data::CollPtr coll = Data::Document::self()->collection();
  if(!coll || coll->type() != Data::Collection::Bibtex) {
    return TQStringList();
  }
  return BibtexHandler::bibtexKeys(Controller::self()->selectedEntries());
}

TQString CollectionInterface::bibtexKey(long id_) const {
  Data::CollPtr coll = Data::Document::self()->collection();
  if(!coll || coll->type() != Data::Collection::Bibtex) {
    return TQString();
  }
  Data::EntryPtr entry = coll->entryById(id_);
  if(!entry) {
    return TQString();
  }
  return BibtexHandler::bibtexKeys(entry).first();
}

bool CollectionInterface::setFieldValue(long id_, const TQString& fieldName_, const TQString& value_) {
  Data::CollPtr coll = Data::Document::self()->collection();
  if(!coll) {
    return false;
  }
  Data::EntryPtr entry = coll->entryById(id_);
  if(!entry) {
    return false;
  }
  Data::EntryPtr oldEntry = new Data::Entry(*entry);
  if(!entry->setField(fieldName_, value_)) {
    return false;
  }
  Kernel::self()->modifyEntries(oldEntry, entry);
  return true;
}

bool CollectionInterface::addFieldValue(long id_, const TQString& fieldName_, const TQString& value_) {
  Data::CollPtr coll = Data::Document::self()->collection();
  if(!coll) {
    return false;
  }
  Data::EntryPtr entry = coll->entryById(id_);
  if(!entry) {
    return false;
  }
  Data::EntryPtr oldEntry = new Data::Entry(*entry);
  TQStringList values = entry->fields(fieldName_, false);
  TQStringList newValues = values;
  newValues << value_;
  if(!entry->setField(fieldName_, newValues.join(TQString::fromLatin1("; ")))) {
    return false;
  }
  Kernel::self()->modifyEntries(oldEntry, entry);
  return true;
}
