/***************************************************************************
    copyright            : (C) 2007 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_FETCH_CROSSREFFETCHER_H
#define TELLICO_FETCH_CROSSREFFETCHER_H

#include "fetcher.h"
#include "configwidget.h"
#include "../datavectors.h"

#include <tdeio/job.h>

#include <tqcstring.h> // for TQByteArray
#include <tqguardedptr.h>

class KLineEdit;

namespace Tellico {

  class XSLTHandler;

  namespace Fetch {

/**
 * @author Robby Stephenson
 */
class CrossRefFetcher : public Fetcher {
TQ_OBJECT
  

public:
  CrossRefFetcher(TQObject* parent);
  ~CrossRefFetcher();

  virtual TQString source() const;
  virtual bool isSearching() const { return m_started; }
  virtual void search(FetchKey key, const TQString& value);

  virtual bool canSearch(FetchKey k) const { return k == DOI; }
  virtual void stop();
  virtual Data::EntryPtr fetchEntry(uint uid);
  virtual Type type() const { return CrossRef; }
  virtual bool canFetch(int type) const;
  virtual void readConfigHook(const TDEConfigGroup& config);

  virtual void updateEntry(Data::EntryPtr entry);
  virtual void updateEntrySynchronous(Data::EntryPtr entry);

  virtual Fetch::ConfigWidget* configWidget(TQWidget* parent) const;

  class ConfigWidget : public Fetch::ConfigWidget {
  public:
    ConfigWidget(TQWidget* parent_, const CrossRefFetcher* fetcher = 0);
    virtual void saveConfig(TDEConfigGroup& config);
    virtual TQString preferredName() const;
  private:
    KLineEdit* m_userEdit;
    KLineEdit* m_passEdit;
  };
  friend class ConfigWidget;

  static TQString defaultName();

private slots:
  void slotData(TDEIO::Job* job, const TQByteArray& data);
  void slotComplete(TDEIO::Job* job);

private:
  void initXSLTHandler();
  KURL searchURL(FetchKey key, const TQString& value) const;

  XSLTHandler* m_xsltHandler;

  TQString m_user;
  TQString m_password;

  TQByteArray m_data;
  TQMap<int, Data::EntryPtr> m_entries;
  TQGuardedPtr<TDEIO::Job> m_job;

  FetchKey m_key;
  TQString m_value;
  bool m_started;
};

  }
}
#endif
