/***************************************************************************
    copyright            : (C) 2004-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef IMDBFETCHER_H
#define IMDBFETCHER_H

#include "fetcher.h"
#include "configwidget.h"
#include "../datavectors.h"

#include <kurl.h>
#include <tdeio/job.h>

#include <tqcstring.h> // for TQByteArray
#include <tqmap.h>
#include <tqguardedptr.h>

class KLineEdit;
class KIntSpinBox;
class TQCheckBox;
class TQRegExpr;

namespace Tellico {
  namespace Fetch {

/**
 * @author Robby Stephenson
 */
class IMDBFetcher : public Fetcher {
TQ_OBJECT
  

public:
  IMDBFetcher(TQObject* parent, const char* name=0);
  /**
   */
  virtual ~IMDBFetcher();

  virtual TQString source() const;
  virtual bool isSearching() const { return m_started; }
  virtual void search(FetchKey key, const TQString& value);
  virtual void continueSearch();
  // imdb can search title, person
  virtual bool canSearch(FetchKey k) const { return k == Title || k == Person; }
  virtual void stop();
  virtual Data::EntryPtr fetchEntry(uint uid);
  virtual Type type() const { return IMDB; }
  virtual bool canFetch(int type) const;
  virtual void readConfigHook(const TDEConfigGroup& config);

  virtual void updateEntry(Data::EntryPtr entry);

  virtual Fetch::ConfigWidget* configWidget(TQWidget* parent) const;

  static StringMap customFields();

  class ConfigWidget : public Fetch::ConfigWidget {
  public:
    ConfigWidget(TQWidget* parent_, const IMDBFetcher* fetcher = 0);
    virtual void saveConfig(TDEConfigGroup& config);
    virtual TQString preferredName() const;

  private:
    KLineEdit* m_hostEdit;
    TQCheckBox* m_fetchImageCheck;
    KIntSpinBox* m_numCast;
  };
  friend class ConfigWidget;

  static TQString defaultName();

private slots:
  void slotData(TDEIO::Job* job, const TQByteArray& data);
  void slotComplete(TDEIO::Job* job);
  void slotRedirection(TDEIO::Job* job, const KURL& toURL);

private:
  static void initRegExps();
  static TQRegExp* s_tagRx;
  static TQRegExp* s_anchorRx;
  static TQRegExp* s_anchorTitleRx;
  static TQRegExp* s_anchorNameRx;
  static TQRegExp* s_titleRx;

  void doTitle(const TQString& s, Data::EntryPtr e);
  void doRunningTime(const TQString& s, Data::EntryPtr e);
  void doAspectRatio(const TQString& s, Data::EntryPtr e);
  void doAlsoKnownAs(const TQString& s, Data::EntryPtr e);
  void doPlot(const TQString& s, Data::EntryPtr e, const KURL& baseURL_);
  void doPerson(const TQString& s, Data::EntryPtr e,
                const TQString& imdbHeader, const TQString& fieldName);
  void doCast(const TQString& s, Data::EntryPtr e, const KURL& baseURL_);
  void doLists(const TQString& s, Data::EntryPtr e);
  void doRating(const TQString& s, Data::EntryPtr e);
  void doCover(const TQString& s, Data::EntryPtr e, const KURL& baseURL);

  void parseSingleTitleResult();
  void parseSingleNameResult();
  void parseMultipleTitleResults();
  void parseTitleBlock(const TQString& str);
  void parseMultipleNameResults();
  Data::EntryPtr parseEntry(const TQString& str);

  TQByteArray m_data;
  TQMap<int, Data::EntryPtr> m_entries;
  TQMap<int, KURL> m_matches;
  TQGuardedPtr<TDEIO::Job> m_job;

  FetchKey m_key;
  TQString m_value;
  bool m_started;
  bool m_fetchImages;

  TQString m_host;
  int m_numCast;
  KURL m_url;
  bool m_redirected;
  uint m_limit;
  TQStringList m_fields;

  TQString m_popularTitles;
  TQString m_exactTitles;
  TQString m_partialTitles;
  enum TitleBlock { Unknown = 0, Popular = 1, Exact = 2, Partial = 3, SinglePerson = 4};
  TitleBlock m_currentTitleBlock;
  int m_countOffset;
};

  } // end namespace
} // end namespace

#endif
