###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


# required stuff
find_package( TQt )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
    tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### get commit hash information
execute_process(
  COMMAND git describe --abbrev=8 --dirty --always
  OUTPUT_VARIABLE GIT_HASH
  OUTPUT_STRIP_TRAILING_WHITESPACE
)


##### check for stream support

check_cxx_source_compiles(
  "
  #include <sstream>
  int main()
  {
    std::istringstream sstream;
    return 0;
  }
  "
  HAVE_SSTREAM
)

check_cxx_source_compiles(
  "
  #include <strstream>
  int main()
  {
    std::istrstream strstream;
    return 0;
  }
  "
  HAVE_STRSTREAM
)

if( NOT HAVE_SSTREAM AND NOT HAVE_STRSTREAM )
  message(FATAL_ERROR "\nsstream or strstream support is required, but not found on your system." )
endif( )

# check for tqscintilla
pkg_search_module( TQSCINTILLA tqscintilla )
if( NOT TQSCINTILLA_FOUND )
  tde_message_fatal( "tqscintilla is required, but was not found on your system" )
endif( )
