/***************************************************************************
 *   Copyright (C) 2003-2005 by The Amarok Developers                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#ifndef COLLECTIONSCANNER_H
#define COLLECTIONSCANNER_H

#include "metabundle.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <tqmap.h>
#include <tqstringlist.h>

#include <tdeapplication.h>

typedef TQMap<TQString, TQString> AttributeMap;


/**
 * @class CollectionScanner
 * @short Scans directories and builds the Collection
 */

class CollectionScanner : public TDEApplication
{
    TQ_OBJECT
  

public:
    CollectionScanner( const TQStringList& folders,
                       bool recursive,
                       bool incremental,
                       bool importPlaylists,
                       bool restart );

    ~CollectionScanner();
    int newInstance() { return 0; }

public slots:
    void pause();
    void resume();

private slots:
    void doJob();

private:
    void readDir( const TQString& dir, TQStringList& entries );
    void scanFiles( const TQStringList& entries );

    /**
     * Read metadata tags of a given file.
     * @mb MetaBundle for the file.
     * @return TQMap containing tags, or empty TQMap on failure.
     */
    AttributeMap readTags( const MetaBundle& mb );

    /**
     * Helper method for writing XML elements to stdout.
     * @name Name of the element.
     * @attributes Key/value map of attributes.
     */
    void writeElement( const TQString& name, const AttributeMap& attributes );


    /**
     * @return the LOWERCASE file extension without the preceding '.', or "" if there is none
     */
    inline TQString extension( const TQString &fileName )
    {
        return fileName.contains( '.' ) ? fileName.mid( fileName.findRev( '.' ) + 1 ).lower() : "";
    }

    /**
     * @return the last directory in @param fileName
     */
    inline TQString directory( const TQString &fileName )
    {
        return fileName.section( '/', 0, -2 );
    }


    const bool    m_importPlaylists;
    TQStringList   m_folders;
    const bool    m_recursively;
    const bool    m_incremental;
    const bool    m_restart;
    const TQString m_logfile;
    bool          m_pause;

    struct direntry {
      dev_t dev;
      ino_t ino;
    } TDE_PACKED;

    TQMemArray<direntry> m_processedDirs;
};


#endif // COLLECTIONSCANNER_H
